/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.runtime.standalone.reflect.ReflectUtils;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class NElementMapperEnum
implements NElementMapper<Enum> {
    private static Map<Class, LenientParser> cache = new HashMap<Class, LenientParser>();

    @Override
    public Object destruct(Enum src, Type typeOfSrc, NElementFactoryContext context) {
        return src;
    }

    @Override
    public NElement createElement(Enum o, Type typeOfSrc, NElementFactoryContext context) {
        if (o instanceof NEnum) {
            return NElement.ofString(((NEnum)((Object)o)).id());
        }
        return NElement.ofString(String.valueOf(o));
    }

    @Override
    public Enum createObject(NElement o, Type to, NElementFactoryContext context) {
        switch (o.type()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return (Enum)((Class)to).getEnumConstants()[o.asLiteral().asInt().get()];
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: 
            case CHAR: 
            case NAME: {
                Class cc = ReflectUtils.getRawClass(to);
                String name = o.asStringValue().get();
                if (NEnum.class.isAssignableFrom(cc)) {
                    return (Enum)NEnum.parse(cc, name).get();
                }
                try {
                    return Enum.valueOf(cc, name);
                }
                catch (RuntimeException ex) {
                    LenientParser y = cache.computeIfAbsent(cc, LenientParser::new);
                    Object o2 = y.get(name);
                    if (o2 != null) {
                        return (Enum)o2;
                    }
                    throw ex;
                }
            }
        }
        throw new NUnsupportedEnumException(o.type());
    }

    private static class LenientParser {
        Map<String, Object> fields_exact = new HashMap<String, Object>();
        Map<String, Object> fields_lower = new HashMap<String, Object>();
        Map<String, Object> fields_shrink = new HashMap<String, Object>();
        Map<String, Object> exact = new HashMap<String, Object>();
        Map<String, Object> lower = new HashMap<String, Object>();
        Map<String, Object> lowerShrink = new HashMap<String, Object>();

        public LenientParser(Class enumClass) {
            T[] enumConstants = enumClass.getEnumConstants();
            if (enumConstants != null) {
                String s;
                for (Object t : enumConstants) {
                    s = String.valueOf(t);
                    this.exact.put(s, t);
                    String lowerCased = s.toLowerCase();
                    this.lower.put(lowerCased, t);
                    lowerCased = lowerCased.replace("_", "");
                    this.lowerShrink.put(lowerCased, t);
                }
                if (this.exact.size() != enumConstants.length) {
                    this.exact.clear();
                }
                if (this.lower.size() != enumConstants.length) {
                    this.lower.clear();
                }
                if (this.lowerShrink.size() != enumConstants.length) {
                    this.lowerShrink.clear();
                }
                for (Field field : enumClass.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !field.getType().equals(enumClass)) continue;
                    s = field.getName();
                    Object enumConstant = null;
                    try {
                        enumConstant = field.get(null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    if (enumConstant == null) continue;
                    this.fields_exact.put(s, enumConstant);
                    String lowerCased = s.toLowerCase();
                    this.fields_lower.put(lowerCased, enumConstant);
                    lowerCased = lowerCased.replace("_", "");
                    this.fields_shrink.put(lowerCased, enumConstant);
                }
            }
        }

        public Object get(String name) {
            Object r = this.exact.get(name);
            if (r != null) {
                return (Enum)r;
            }
            String lowerCased = name.toLowerCase();
            r = this.lower.get(lowerCased);
            if (r != null) {
                return (Enum)r;
            }
            String lowerCased2 = lowerCased.replace("_", "");
            r = this.lowerShrink.get(lowerCased2);
            if (r != null) {
                return (Enum)r;
            }
            r = this.fields_exact.get(name);
            if (r != null) {
                return (Enum)r;
            }
            r = this.fields_lower.get(lowerCased);
            if (r != null) {
                return (Enum)r;
            }
            r = this.fields_shrink.get(lowerCased2);
            if (r != null) {
                return (Enum)r;
            }
            return null;
        }
    }
}

