/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringBuilder;

public class NElementCommentsImpl
implements NElementComments {
    public static final NElementComments BLANK = new NElementCommentsImpl();
    private NElementComment[] leadingComments;
    private NElementComment[] trailingComments;

    private static NElementComment[] _trim(NElementComment[] all) {
        ArrayList<NElementComment> ok = new ArrayList<NElementComment>();
        if (all != null) {
            for (NElementComment a : all) {
                if (a == null || a.text().isEmpty()) continue;
                ok.add(a);
            }
        }
        return ok.toArray(new NElementComment[0]);
    }

    public static NElementComments ofLeading(NElementComment ... all) {
        return new NElementCommentsImpl(all, null);
    }

    public static NElementComments ofTrailing(NElementComment ... all) {
        return new NElementCommentsImpl(null, all);
    }

    public static NElementComments ofTrailing(NElementComment[] leading, NElementComment[] trailing) {
        return new NElementCommentsImpl(leading, trailing);
    }

    public NElementCommentsImpl() {
        this.leadingComments = new NElementComment[0];
        this.trailingComments = new NElementComment[0];
    }

    public NElementCommentsImpl(NElementComment[] leadingComments, NElementComment[] trailingComments) {
        this.leadingComments = NElementCommentsImpl._trim(leadingComments);
        this.trailingComments = NElementCommentsImpl._trim(trailingComments);
    }

    public static NElementComments concat(NElementCommentsImpl a, NElementCommentsImpl b) {
        if (a == null && b == null) {
            return null;
        }
        if (a != null) {
            return a.concat(b);
        }
        return b;
    }

    public String toString() {
        NStringBuilder sb = new NStringBuilder();
        for (NElementComment leadingComment : this.leadingComments) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(leadingComment);
        }
        for (NElementComment ec : this.trailingComments) {
            sb.append("\n");
            sb.append(ec);
        }
        return sb.toString();
    }

    public NElementComments concat(NElementComments other) {
        if (other != null) {
            ArrayList<NElementComment> a = new ArrayList<NElementComment>();
            ArrayList<NElementComment> b = new ArrayList<NElementComment>();
            a.addAll(this.leadingComments());
            a.addAll(other.leadingComments());
            b.addAll(this.trailingComments());
            b.addAll(other.trailingComments());
            return new NElementCommentsImpl(a.toArray(new NElementComment[0]), b.toArray(new NElementComment[0]));
        }
        return this;
    }

    @Override
    public List<NElementComment> trailingComments() {
        return Arrays.asList(this.trailingComments);
    }

    @Override
    public List<NElementComment> leadingComments() {
        return Arrays.asList(this.leadingComments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NElementCommentsImpl that = (NElementCommentsImpl)o;
        return Objects.deepEquals(this.leadingComments, that.leadingComments) && Objects.deepEquals(this.trailingComments, that.trailingComments);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.leadingComments), Arrays.hashCode(this.trailingComments));
    }

    @Override
    public boolean isBlank() {
        return !(this.leadingComments.length != 0 && !Arrays.stream(this.leadingComments).allMatch(NBlankable::isBlank) || this.trailingComments.length != 0 && !Arrays.stream(this.trailingComments).allMatch(NBlankable::isBlank));
    }

    @Override
    public boolean isEmpty() {
        return this.leadingComments.length == 0 && this.trailingComments.length == 0;
    }

    @Override
    public int compareTo(NElementComments o) {
        int i = NElementCommentsImpl.compareLists(this.leadingComments(), o.leadingComments());
        if (i != 0) {
            return i;
        }
        i = NElementCommentsImpl.compareLists(this.trailingComments(), o.trailingComments());
        if (i != 0) {
            return i;
        }
        return 0;
    }

    private static <T extends Comparable<T>> int compareLists(List<T> a1, List<T> a2) {
        for (int j = 0; j < Math.max(a1.size(), a2.size()); ++j) {
            if (j >= a1.size()) {
                return -1;
            }
            if (j >= a2.size()) {
                return 1;
            }
            int i = ((Comparable)a1.get(j)).compareTo((Comparable)a2.get(j));
            if (i == 0) continue;
            return i;
        }
        return 0;
    }
}

