/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.runtime.standalone.elem.NElementToStringHelper;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class NElementAnnotationImpl
implements NElementAnnotation {
    private final String name;
    private final NElement[] params;

    public NElementAnnotationImpl(String name, NElement[] params) {
        this.name = name;
        this.params = params;
    }

    @Override
    public boolean isCustomTree() {
        if (this.params != null) {
            for (NElement param : this.params) {
                if (!param.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public boolean isNamed() {
        return !this.name.isEmpty();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int size() {
        return this.params == null ? 0 : this.params.length;
    }

    @Override
    public NElement param(int index) {
        return this.params[index];
    }

    @Override
    public List<NElement> params() {
        return this.params == null ? null : Arrays.asList(this.params);
    }

    @Override
    public boolean isBlank() {
        return NBlankable.isBlank(this.name) && (this.params == null || this.params.length == 0);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean compact) {
        NStringBuilder sb = new NStringBuilder();
        NElementToStringHelper.appendUplet("@" + NStringUtils.trim(this.name), null, compact, sb);
        if (this.params != null) {
            sb.append("(");
            NElementToStringHelper.appendChildren(this.params(), compact, new NElementToStringHelper.SemiCompactInfo().setMaxChildren(10).setMaxLineSize(120), sb);
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NElementAnnotationImpl that = (NElementAnnotationImpl)object;
        return Objects.equals(this.name, that.name) && Objects.deepEquals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.name, Arrays.hashCode(this.params));
    }
}

