/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElementUtils;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.NElementToStringHelper;
import net.thevpc.nuts.runtime.standalone.elem.item.AbstractNListContainerElement;
import net.thevpc.nuts.runtime.standalone.elem.path.NElementPathImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNUpletElement
extends AbstractNListContainerElement
implements NUpletElement {
    private final NElement[] params;
    private String name;

    public DefaultNUpletElement(String name, Collection<NElement> params, NElementAnnotation[] annotations, NElementComments comments) {
        super(name == null ? NElementType.UPLET : NElementType.NAMED_UPLET, annotations, comments);
        if (name != null) {
            NAssert.requireTrue(NElementUtils.isValidElementName(name), "valid name : " + name);
        }
        this.params = params.toArray(new NElement[0]);
        this.name = name;
    }

    public DefaultNUpletElement(String name, NElement[] params, NElementAnnotation[] annotations, NElementComments comments) {
        super(name == null ? NElementType.UPLET : NElementType.NAMED_UPLET, annotations, comments);
        this.params = Arrays.copyOf(params, params.length);
        this.name = name;
    }

    @Override
    public boolean isCustomTree() {
        if (super.isCustomTree()) {
            return true;
        }
        if (this.params != null) {
            for (NElement value : this.params) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<NElement> resolveAll(String pattern) {
        pattern = NStringUtils.trimToNull(pattern);
        NElementPathImpl pp = new NElementPathImpl(pattern);
        NElement[] nElements = pp.resolveReversed(this);
        return new ArrayList<NElement>(Arrays.asList(nElements));
    }

    @Override
    public boolean isNamed(String name) {
        return this.isNamed() && Objects.equals(name, this.name);
    }

    @Override
    public NOptional<String> name() {
        return NOptional.ofNamed(this.name, this.name);
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public List<NElement> params() {
        return Arrays.asList(this.params);
    }

    @Override
    public List<NElement> children() {
        return Arrays.asList(this.params);
    }

    @Override
    public int size() {
        return this.params.length;
    }

    @Override
    public Stream<NElement> stream() {
        return Arrays.asList(this.params).stream();
    }

    @Override
    public NOptional<NElement> get(int index) {
        if (index >= 0 && index < this.params.length) {
            return NOptional.of(this.params[index]);
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid array index %s not in [%s,%s[", index, 0, this.params.length));
    }

    @Override
    public NOptional<NElement> getAt(int index) {
        if (index >= 0 && index < this.params.length) {
            return NOptional.of(this.params[index]);
        }
        return NOptional.ofError(() -> NMsg.ofC("invalid array index %s not in [%s,%s[", index, 0, this.params.length));
    }

    @Override
    public NUpletElementBuilder builder() {
        return NElement.ofUpletBuilder().copyFrom(this);
    }

    @Override
    public Iterator<NElement> iterator() {
        return Arrays.asList(this.params).iterator();
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean compact) {
        NStringBuilder sb = new NStringBuilder();
        sb.append(NElementToStringHelper.leadingCommentsAndAnnotations(this, compact));
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.params != null) {
            sb.append("(");
            NElementToStringHelper.appendChildren(Arrays.asList(this.params), compact, new NElementToStringHelper.SemiCompactInfo().setMaxChildren(3).setMaxLineSize(120), sb);
            sb.append(")");
        }
        sb.append(NElementToStringHelper.trailingComments(this, compact));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultNUpletElement nElements = (DefaultNUpletElement)o;
        return Objects.deepEquals(this.params, nElements.params) && Objects.equals(this.name, nElements.name());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.params), this.name);
    }

    @Override
    public boolean isEmpty() {
        return this.params.length == 0;
    }

    @Override
    public boolean isBlank() {
        return this.params.length == 0 && NBlankable.isBlank(this.name);
    }

    @Override
    public NOptional<NElement> get(String s) {
        for (NElement x : this.params) {
            if (!(x instanceof NPairElement)) continue;
            NPairElement e = (NPairElement)x;
            if (!(s == null ? e.key().isNull() : e.key().isAnyString() && Objects.equals(e.key().asStringValue().get(), s))) continue;
            return NOptional.of(e.value());
        }
        return NOptional.ofNamedEmpty("property " + s);
    }

    @Override
    public List<NElement> getAll(String s) {
        ArrayList<NElement> ret = new ArrayList<NElement>();
        for (NElement x : this.params) {
            if (!(x instanceof NPairElement)) continue;
            NPairElement e = (NPairElement)x;
            if (s == null) {
                if (!e.key().isNull()) continue;
                ret.add(e.value());
                continue;
            }
            if (!e.key().isAnyString() || !Objects.equals(e.key().asStringValue().get(), s)) continue;
            ret.add(e.value());
        }
        return ret;
    }

    @Override
    public NOptional<NElement> get(NElement key) {
        return key.isString() ? key.asStringValue().flatMap(this::get) : key.asIntValue().flatMap(this::get);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<NElement> getAll(NElement s) {
        int index = -1;
        if (s.isString()) {
            NOptional<Integer> ii = s.asLiteral().asInt();
            if (!ii.isPresent()) return Collections.emptyList();
            index = ii.get();
        } else {
            if (!s.asIntValue().isPresent()) return Collections.emptyList();
            index = s.asIntValue().get();
        }
        NOptional<NElement> a = this.get(index);
        if (!a.isPresent()) return Collections.emptyList();
        return Arrays.asList(a.get());
    }
}

