/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElementUtils;
import net.thevpc.nuts.elem.NNumberElement;
import net.thevpc.nuts.elem.NNumberLayout;
import net.thevpc.nuts.elem.NPrimitiveElement;
import net.thevpc.nuts.elem.NPrimitiveElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.NElementToStringHelper;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNPrimitiveElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.AbstractNElement;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNPrimitiveElement
extends AbstractNElement
implements NPrimitiveElement {
    private final Object value;

    public DefaultNPrimitiveElement(NElementType type, Object value, NElementAnnotation[] annotations, NElementComments comments) {
        super(type, annotations, comments);
        if (type == NElementType.NAME) {
            NAssert.requireTrue(NElementUtils.isValidElementName((String)value), "valid name : " + (String)value);
        }
        this.value = value;
    }

    @Override
    public List<NElement> resolveAll(String pattern) {
        if ((pattern = NStringUtils.trimToNull(pattern)) == null || pattern.equals(".")) {
            return new ArrayList<NElement>(Arrays.asList(this));
        }
        return new ArrayList<NElement>();
    }

    @Override
    public Object value() {
        return NLiteral.of(this.value).asObject().orNull();
    }

    @Override
    public boolean isEmpty() {
        return NLiteral.of(this.value).isEmpty();
    }

    @Override
    public boolean isBlank() {
        return NLiteral.of(this.value).isBlank();
    }

    @Override
    public NOptional<BigInteger> asBigIntValue() {
        return NLiteral.of(this.value).asBigInt();
    }

    @Override
    public NOptional<BigDecimal> asBigDecimalValue() {
        return NLiteral.of(this.value).asBigDecimal();
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean compact) {
        NStringBuilder sb = new NStringBuilder();
        sb.append(NElementToStringHelper.leadingCommentsAndAnnotations(this, compact));
        switch (this.type()) {
            case NULL: {
                sb.append("null");
                break;
            }
            case CHAR: {
                sb.append(NStringUtils.formatStringLiteral(String.valueOf(this.value), NElementType.SINGLE_QUOTED_STRING));
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                sb.append(NStringUtils.formatStringLiteral(String.valueOf(this.value), this.type()));
                break;
            }
            case BYTE: 
            case LONG: 
            case BIG_DECIMAL: 
            case BIG_INT: 
            case SHORT: 
            case INT: 
            case FLOAT: 
            case DOUBLE: {
                NNumberElement r = this.asNumber().get();
                NNumberLayout layout = r.numberLayout();
                String suffix = r.numberSuffix();
                switch (layout) {
                    case DECIMAL: {
                        sb.append(String.valueOf(this.asNumberValue().get()));
                        break;
                    }
                    case HEXADECIMAL: {
                        sb.append(this.asBigIntValue().get().toString(16));
                        break;
                    }
                    case OCTAL: {
                        sb.append(this.asBigIntValue().get().toString(8));
                        break;
                    }
                    case BINARY: {
                        sb.append(this.asBigIntValue().get().toString(2));
                    }
                }
                if (NBlankable.isBlank(suffix)) break;
                sb.append(suffix);
                break;
            }
            default: {
                sb.append(String.valueOf(this.value));
            }
        }
        sb.append(NElementToStringHelper.trailingComments(this, compact));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNPrimitiveElement that = (DefaultNPrimitiveElement)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @Override
    public NPrimitiveElementBuilder builder() {
        return new DefaultNPrimitiveElementBuilder().copyFrom(this);
    }

    @Override
    public NLiteral asLiteral() {
        return NLiteral.of(this.value);
    }

    @Override
    public NOptional<Temporal> asTemporalValue() {
        if (this.value != null && this.value instanceof Temporal) {
            return NOptional.of((Temporal)this.value);
        }
        return super.asTemporalValue();
    }
}

