/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElementUtils;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.runtime.standalone.elem.NElementToStringHelper;
import net.thevpc.nuts.runtime.standalone.elem.item.AbstractNListContainerElement;
import net.thevpc.nuts.runtime.standalone.elem.path.NElementPathImpl;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNObjectElement
extends AbstractNListContainerElement
implements NObjectElement {
    private List<NElement> values = new ArrayList<NElement>();
    private String name;
    private List<NElement> params;

    public DefaultNObjectElement(String name, List<NElement> params, List<NElement> values, NElementAnnotation[] annotations, NElementComments comments) {
        super(name == null && params == null ? NElementType.OBJECT : (name == null && params != null ? NElementType.PARAMETRIZED_OBJECT : (name != null && params == null ? NElementType.NAMED_OBJECT : NElementType.NAMED_PARAMETRIZED_OBJECT)), annotations, comments);
        if (name != null) {
            NAssert.requireTrue(NElementUtils.isValidElementName(name), "valid name : " + name);
        }
        this.name = name;
        this.params = params;
        if (values != null) {
            for (NElement e : values) {
                if (e == null) continue;
                this.values.add(e);
            }
        }
    }

    @Override
    public boolean isCustomTree() {
        if (super.isCustomTree()) {
            return true;
        }
        if (this.params != null) {
            for (NElement value : this.params) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        if (this.values != null) {
            for (NElement value : this.values) {
                if (!value.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNamed(String name) {
        return this.isNamed() && Objects.equals(name, this.name);
    }

    @Override
    public List<NPairElement> pairs() {
        return this.values.stream().filter(NElement::isPair).map(x -> x.asPair().get()).collect(Collectors.toList());
    }

    @Override
    public Iterator<NElement> iterator() {
        return this.children().iterator();
    }

    @Override
    public NOptional<NElement> get(int index) {
        if (index < 0 || index >= this.values.size()) {
            return NOptional.ofNamedEmpty("property at " + index);
        }
        return NOptional.of(this.values.get(index));
    }

    @Override
    public NOptional<NElement> getAt(int index) {
        if (index < 0 || index >= this.values.size()) {
            return NOptional.ofNamedEmpty("property at " + index);
        }
        return NOptional.of(this.values.get(index));
    }

    @Override
    public NOptional<NElement> get(String s) {
        NElements elements = NElements.of();
        for (NElement x : this.values) {
            if (!(x instanceof NPairElement)) continue;
            NPairElement e = (NPairElement)x;
            if (!(s == null ? e.key().isNull() : e.key().isAnyString() && Objects.equals(e.key().asStringValue().get(), s))) continue;
            return NOptional.of(e.value());
        }
        return NOptional.ofNamedEmpty("property " + s);
    }

    @Override
    public List<NElement> getAll(String s) {
        ArrayList<NElement> ret = new ArrayList<NElement>();
        for (NElement x : this.values) {
            if (!(x instanceof NPairElement)) continue;
            NPairElement e = (NPairElement)x;
            if (s == null) {
                if (!e.key().isNull()) continue;
                ret.add(e.value());
                continue;
            }
            if (!e.key().isAnyString() || !Objects.equals(e.key().asStringValue().get(), s)) continue;
            ret.add(e.value());
        }
        return ret;
    }

    @Override
    public NOptional<NElement> get(NElement s) {
        List<NElement> a = this.getAll(s);
        return NOptional.ofNamedSingleton(a, "property " + s);
    }

    @Override
    public List<NElement> getAll(NElement s) {
        ArrayList<NElement> ret = new ArrayList<NElement>();
        for (NElement x : this.values) {
            NPairElement e;
            if (!(x instanceof NPairElement) || !Objects.equals((e = (NPairElement)x).key(), s)) continue;
            ret.add(e.value());
        }
        return ret;
    }

    @Override
    public List<NElement> children() {
        return new ArrayList<NElement>(this.values);
    }

    @Override
    public Stream<NElement> stream() {
        return this.values.stream();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public NObjectElementBuilder builder() {
        return NElement.ofObjectBuilder().copyFrom(this);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.values);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNObjectElement other = (DefaultNObjectElement)obj;
        return Objects.equals(this.values, other.values);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean compact) {
        NStringBuilder sb = new NStringBuilder();
        sb.append(NElementToStringHelper.leadingCommentsAndAnnotations(this, compact));
        NElementToStringHelper.appendUplet(this.name, this.params, compact, sb);
        sb.append("{");
        NElementToStringHelper.appendChildren(this.children(), compact, new NElementToStringHelper.SemiCompactInfo().setMaxChildren(10).setMaxLineSize(120), sb);
        sb.append("}");
        sb.append(NElementToStringHelper.trailingComments(this, compact));
        return sb.toString();
    }

    @Override
    public boolean isBlank() {
        return this.values.isEmpty();
    }

    @Override
    public NOptional<String> name() {
        return NOptional.ofNamed(this.name, this.name);
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public NOptional<List<NElement>> params() {
        return this.params == null ? NOptional.ofNamedEmpty("params") : NOptional.of(Collections.unmodifiableList(this.params));
    }

    @Override
    public int paramsCount() {
        return this.params == null ? null : Integer.valueOf(this.params.size());
    }

    @Override
    public NElement param(int index) {
        return this.params == null ? null : this.params.get(index);
    }

    @Override
    public List<NElement> resolveAll(String pattern) {
        pattern = NStringUtils.trimToNull(pattern);
        NElementPathImpl pp = new NElementPathImpl(pattern);
        NElement[] nElements = pp.resolveReversed(this);
        return new ArrayList<NElement>(Arrays.asList(nElements));
    }
}

