/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NNumberElement;
import net.thevpc.nuts.elem.NNumberLayout;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNPrimitiveElement;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNNumberElement
extends DefaultNPrimitiveElement
implements NNumberElement {
    private NNumberLayout layout;
    private String suffix;

    public DefaultNNumberElement(NElementType type, Number value) {
        this(type, value, null, null, null, null);
    }

    public DefaultNNumberElement(NElementType type, Number value, NNumberLayout layout, String suffix) {
        this(type, value, layout, suffix, null, null);
    }

    public DefaultNNumberElement(NElementType type, Number value, NNumberLayout layout, String suffix, NElementAnnotation[] annotations, NElementComments comments) {
        super(type, value, annotations, comments);
        this.layout = layout == null ? NNumberLayout.DECIMAL : layout;
        this.suffix = NStringUtils.trimToNull(suffix);
    }

    @Override
    public Number numberValue() {
        return (Number)this.value();
    }

    @Override
    public NNumberLayout numberLayout() {
        return this.layout;
    }

    @Override
    public String numberSuffix() {
        return this.suffix;
    }

    @Override
    public NOptional<NNumberElement> asNumber() {
        return NOptional.of(this);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        Number d = this.numberValue();
        if (d instanceof BigDecimal) {
            return (BigDecimal)d;
        }
        if (d instanceof BigInteger) {
            return new BigDecimal(d.toString());
        }
        return BigDecimal.valueOf(d.doubleValue());
    }

    @Override
    public BigInteger bigIntegerValue() {
        Number d = this.numberValue();
        if (d instanceof BigDecimal) {
            return ((BigDecimal)d).toBigInteger();
        }
        if (d instanceof BigInteger) {
            return (BigInteger)d;
        }
        return BigInteger.valueOf(d.longValue());
    }

    @Override
    public NOptional<NElement> asNumberType(NElementType elemType) {
        NOptional<Object> newValue;
        if (elemType == null || elemType == this.type()) {
            return NOptional.of(this);
        }
        switch (elemType) {
            case BYTE: {
                newValue = NLiteral.of(this.value()).asByte();
                break;
            }
            case SHORT: {
                newValue = NLiteral.of(this.value()).asShort();
                break;
            }
            case INT: {
                newValue = NLiteral.of(this.value()).asInt();
                break;
            }
            case LONG: {
                newValue = NLiteral.of(this.value()).asLong();
                break;
            }
            case FLOAT: {
                newValue = NLiteral.of(this.value()).asFloat();
                break;
            }
            case DOUBLE: {
                newValue = NLiteral.of(this.value()).asDouble();
                break;
            }
            case BIG_INT: {
                newValue = NLiteral.of(this.value()).asBigInt();
                break;
            }
            case BIG_DECIMAL: {
                newValue = NLiteral.of(this.value()).asBigDecimal();
                break;
            }
            case FLOAT_COMPLEX: {
                newValue = NLiteral.of(this.value()).asFloatComplex();
                break;
            }
            case DOUBLE_COMPLEX: {
                newValue = NLiteral.of(this.value()).asDoubleComplex();
                break;
            }
            case BIG_COMPLEX: {
                newValue = NLiteral.of(this.value()).asBigComplex();
                break;
            }
            default: {
                newValue = NOptional.ofEmpty();
            }
        }
        if (!newValue.isPresent()) {
            return NOptional.ofNamedEmpty(NMsg.ofC("unable to convert %s to %s : %s", this.type(), elemType));
        }
        return NOptional.of(new DefaultNNumberElement(this.type(), (Number)newValue.get(), this.layout, this.suffix, this.annotations().toArray(new NElementAnnotation[0]), this.comments()));
    }
}

