/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.elem.NCustomElement;
import net.thevpc.nuts.elem.NCustomElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.runtime.standalone.elem.NElementToStringHelper;
import net.thevpc.nuts.runtime.standalone.elem.builder.DefaultNCustomElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.AbstractNElement;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNCustomElement
extends AbstractNElement
implements NCustomElement {
    private final Object value;

    public DefaultNCustomElement(Object value, NElementAnnotation[] annotations, NElementComments comments) {
        super(NElementType.CUSTOM, annotations, comments);
        this.value = value;
    }

    @Override
    public boolean isCustomTree() {
        return true;
    }

    @Override
    public NOptional<NElement> resolve(String pattern) {
        if ((pattern = NStringUtils.trimToNull(pattern)) == null || pattern.equals(".")) {
            return NOptional.of(this);
        }
        return NOptional.ofNamedEmpty(pattern);
    }

    @Override
    public List<NElement> resolveAll(String pattern) {
        if ((pattern = NStringUtils.trimToNull(pattern)) == null || pattern.equals(".")) {
            return new ArrayList<NElement>(Arrays.asList(this));
        }
        return new ArrayList<NElement>();
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean compact) {
        NStringBuilder sb = new NStringBuilder();
        sb.append(NElementToStringHelper.leadingCommentsAndAnnotations(this, compact));
        String svalue = String.valueOf(this.value);
        sb.append(svalue);
        sb.append(NElementToStringHelper.trailingComments(this, compact));
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this.value);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNCustomElement other = (DefaultNCustomElement)obj;
        return Objects.equals(this.value, other.value);
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public NCustomElementBuilder builder() {
        return new DefaultNCustomElementBuilder().addAnnotations((List)this.annotations()).value(this.value);
    }
}

