/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NCustomElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementTransform;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElementTypeGroup;
import net.thevpc.nuts.elem.NListContainerElement;
import net.thevpc.nuts.elem.NMatrixElement;
import net.thevpc.nuts.elem.NNamedElement;
import net.thevpc.nuts.elem.NNumberElement;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NOperatorElement;
import net.thevpc.nuts.elem.NOperatorType;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NParametrizedContainerElement;
import net.thevpc.nuts.elem.NPrimitiveElement;
import net.thevpc.nuts.elem.NStringElement;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.math.NBigComplex;
import net.thevpc.nuts.math.NDoubleComplex;
import net.thevpc.nuts.math.NFloatComplex;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementAsLiteral;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementCommentsImpl;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementTransformHelper;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;

public abstract class AbstractNElement
implements NElement {
    private NElementType type;
    private NElementAnnotation[] annotations;
    private NElementComments comments;

    public AbstractNElement(NElementType type, NElementAnnotation[] annotations, NElementComments comments) {
        this.type = type;
        this.annotations = annotations == null ? new NElementAnnotation[]{} : annotations;
        this.comments = comments == null ? new NElementCommentsImpl() : comments;
    }

    @Override
    public boolean isCustomTree() {
        if (this.annotations != null) {
            for (NElementAnnotation annotation : this.annotations) {
                if (!annotation.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NElementComments comments() {
        return this.comments;
    }

    @Override
    public boolean isName() {
        return this.type() == NElementType.NAME;
    }

    @Override
    public boolean isNamedUplet() {
        return this.type() == NElementType.NAMED_UPLET;
    }

    @Override
    public boolean isUplet() {
        return this.type() == NElementType.UPLET;
    }

    @Override
    public boolean isBigDecimal() {
        return this.type() == NElementType.BIG_DECIMAL;
    }

    @Override
    public boolean isBigInt() {
        return this.type() == NElementType.BIG_INT;
    }

    @Override
    public boolean isInstant() {
        return this.type() == NElementType.INSTANT;
    }

    @Override
    public boolean isNamedUplet(String name) {
        return this.type() == NElementType.NAMED_UPLET && Objects.equals(this.asUplet().get().name().orNull(), name);
    }

    @Override
    public boolean isNamedObject() {
        return this.type() == NElementType.NAMED_OBJECT;
    }

    @Override
    public boolean isAnyNamedObject() {
        return this.type().isAnyNamedObject();
    }

    @Override
    public boolean isAnyNamedObject(String name) {
        return this.isAnyNamedObject() && this.isNamed(name);
    }

    @Override
    public boolean isParametrizedObject() {
        return this.type() == NElementType.PARAMETRIZED_OBJECT;
    }

    @Override
    public boolean isNamedParametrizedObject() {
        return this.type().isAnyParametrizedObject();
    }

    @Override
    public boolean isNamedParametrizedObject(String name) {
        return this.type() == NElementType.NAMED_PARAMETRIZED_OBJECT && this.isNamed(name);
    }

    @Override
    public boolean isNamedObject(String name) {
        return this.type() == NElementType.NAMED_OBJECT && this.isNamed(name);
    }

    @Override
    public boolean isAnyArray() {
        return this.type().isAnyArray();
    }

    @Override
    public boolean isAnyObject() {
        return this.type().isAnyObject();
    }

    @Override
    public boolean isListContainer() {
        return this.type().isAnyListContainer();
    }

    @Override
    public NOptional<NNumberElement> asNumber() {
        return NOptional.ofEmpty(this._expected("number"));
    }

    @Override
    public NOptional<NListContainerElement> asListContainer() {
        if (this.isListContainer()) {
            return NOptional.of((NListContainerElement)((Object)this));
        }
        return NOptional.ofEmpty(this._expected("list container"));
    }

    @Override
    public NOptional<NParametrizedContainerElement> asParametrizedContainer() {
        if (this.isListContainer()) {
            return NOptional.of((NParametrizedContainerElement)((Object)this));
        }
        return NOptional.ofEmpty(this._expected("parametrized container"));
    }

    @Override
    public NOptional<NObjectElement> asParametrizedObject() {
        if (this.isParametrizedObject()) {
            return NOptional.of((NObjectElement)((Object)this));
        }
        return NOptional.ofEmpty(this._expected("parametrized object"));
    }

    protected NMsg _expected(String any) {
        return NMsg.ofC("expected a %s, got %s : %s", any, this.type().id(), this.snippet());
    }

    @Override
    public String snippet() {
        return this.snippet(-1);
    }

    @Override
    public String snippet(int size) {
        if (size <= 0) {
            size = 100;
        }
        String s = this.toString(true);
        int u = s.indexOf("\n");
        boolean truncated = false;
        if (u >= 0) {
            s = s.substring(0, u);
            truncated = true;
        }
        if (s.length() > size) {
            s = s.substring(0, size);
            truncated = true;
        }
        if (truncated) {
            return s + "...";
        }
        return s;
    }

    @Override
    public NOptional<NObjectElement> asNamedParametrizedObject(String name) {
        if (this.isNamedParametrizedObject(name)) {
            return NOptional.of((NObjectElement)((Object)this));
        }
        return NOptional.ofEmpty(this._expected("parametrized object " + name));
    }

    @Override
    public NOptional<NNamedElement> asNamed() {
        if (this.isNamed()) {
            return NOptional.of((NNamedElement)((Object)this));
        }
        return NOptional.ofEmpty(this._expected("named element"));
    }

    @Override
    public boolean isAnyMatrix() {
        return this.type().isAnyMatrix();
    }

    @Override
    public boolean isAnyUplet() {
        return this.type().isAnyUplet();
    }

    @Override
    public boolean isNamedArray() {
        return this.type() == NElementType.NAMED_ARRAY;
    }

    @Override
    public boolean isAnyNamedArray() {
        return this.type().isAnyNamedArray();
    }

    @Override
    public boolean isAnyNamedArray(String name) {
        return this.isAnyNamedArray() && this.isNamed(name);
    }

    @Override
    public boolean isParametrizedArray() {
        return this.type() == NElementType.PARAMETRIZED_ARRAY;
    }

    @Override
    public boolean isNamedParametrizedArray() {
        return this.type().isAnyParametrizedArray();
    }

    @Override
    public boolean isNamedParametrizedArray(String name) {
        return this.type() == NElementType.NAMED_PARAMETRIZED_ARRAY && this.isNamed(name);
    }

    @Override
    public boolean isNamedMatrix() {
        return this.type() == NElementType.NAMED_MATRIX;
    }

    @Override
    public boolean isAnyNamedMatrix() {
        return false;
    }

    @Override
    public boolean isAnyNamedMatrix(String name) {
        return this.isNamedMatrix() && this.isNamed(name);
    }

    @Override
    public boolean isParametrizedMatrix() {
        return this.type() == NElementType.PARAMETRIZED_MATRIX;
    }

    @Override
    public boolean isAnyParametrizedMatrix() {
        return this.type().isAnyParametrizedMatrix();
    }

    @Override
    public boolean isAnyParametrizedMatrix(String name) {
        return this.isNamedParametrizedMatrix() && this.isNamed(name);
    }

    @Override
    public boolean isNamedParametrizedMatrix() {
        return this.type() == NElementType.NAMED_PARAMETRIZED_MATRIX;
    }

    @Override
    public boolean isNamed(String name) {
        return this.isNamed() && Objects.equals(this.asNamed().get(), name);
    }

    @Override
    public boolean isNamed(Predicate<String> name) {
        return this.isNamed() && (name == null || name.test(this.asNamed().get().name().get()));
    }

    @Override
    public boolean isName(String name) {
        return this.isName() && Objects.equals(this.asStringValue().get(), name);
    }

    @Override
    public boolean isName(Predicate<String> nameCondition) {
        return this.isName() && (nameCondition == null || nameCondition.test(this.asStringValue().get()));
    }

    @Override
    public boolean isNamedUplet(Predicate<String> nameCondition) {
        return this.isNamedUplet() && this.isNamed(nameCondition);
    }

    @Override
    public boolean isNamedObject(Predicate<String> nameCondition) {
        return this.isNamedObject() && this.isNamed(nameCondition);
    }

    @Override
    public boolean isNamedParametrizedObject(Predicate<String> nameCondition) {
        return this.isNamedParametrizedObject() && this.isNamed(nameCondition);
    }

    @Override
    public boolean isNamedParametrizedMatrix(Predicate<String> nameCondition) {
        return this.isNamedParametrizedMatrix() && this.isNamed(nameCondition);
    }

    @Override
    public boolean isNamedParametrizedMatrix(String name) {
        return this.isNamedParametrizedMatrix() && this.isNamed(name);
    }

    @Override
    public List<NElement> resolveAll(String pattern) {
        return Collections.emptyList();
    }

    @Override
    public NElementBuilder builder() {
        return null;
    }

    @Override
    public List<NElementAnnotation> annotations() {
        return this.annotations == null ? Collections.emptyList() : Arrays.asList(this.annotations);
    }

    @Override
    public List<NElementAnnotation> findAnnotations(String name) {
        return this.annotations().stream().filter(x -> Objects.equals(x.name(), name)).collect(Collectors.toList());
    }

    @Override
    public boolean isAnnotated(String name) {
        return !this.findAnnotations(name).isEmpty();
    }

    @Override
    public NElementType type() {
        return this.type;
    }

    @Override
    public NOptional<NElement> resolve(String pattern) {
        return NOptional.ofNamedSingleton(this.resolveAll(pattern), "resolvable " + pattern);
    }

    @Override
    public NOptional<NPrimitiveElement> asPrimitive() {
        if (this instanceof NPrimitiveElement) {
            return NOptional.of((NPrimitiveElement)((Object)this));
        }
        return NOptional.ofError(() -> NMsg.ofC("unable to cast %s to primitive: %s", this.type().id(), this));
    }

    @Override
    public NOptional<NObjectElement> asObject() {
        if (this instanceof NObjectElement) {
            return NOptional.of((NObjectElement)((Object)this));
        }
        return NOptional.ofError(() -> NMsg.ofC("unable to cast %s to object: %s", this.type().id(), this));
    }

    @Override
    public NOptional<NElement> asElementAt(int index) {
        if (this.type().isAnyListContainer()) {
            return this.asListContainer().map(x -> index >= 0 && index < x.size() ? x.children().get(index) : null);
        }
        return NOptional.ofNamedEmpty("object at " + index);
    }

    @Override
    public NOptional<NUpletElement> asUplet() {
        if (this instanceof NUpletElement) {
            return NOptional.of((NUpletElement)((Object)this));
        }
        return NOptional.ofError(() -> this._expected("uplet"));
    }

    @Override
    public NOptional<NMatrixElement> asMatrix() {
        if (this instanceof NMatrixElement) {
            return NOptional.of((NMatrixElement)((Object)this));
        }
        return NOptional.ofError(() -> this._expected("matrix"));
    }

    @Override
    public NOptional<NNumberElement> asInt() {
        if (this.isInt()) {
            return NOptional.of((NNumberElement)((Object)this));
        }
        return NOptional.ofError(() -> this._expected("int"));
    }

    @Override
    public NOptional<NPairElement> asPair() {
        if (this instanceof NPairElement) {
            return NOptional.of((NPairElement)((Object)this));
        }
        return NOptional.ofError(() -> this._expected("pair"));
    }

    @Override
    public NOptional<NStringElement> asString() {
        if (this instanceof NStringElement) {
            return NOptional.of((NStringElement)((Object)this));
        }
        return NOptional.of((NStringElement)NElement.ofString(this.toString()));
    }

    @Override
    public NOptional<NCustomElement> asCustom() {
        if (this instanceof NCustomElement) {
            return NOptional.of((NCustomElement)((Object)this));
        }
        return NOptional.ofError(() -> this._expected("custom"));
    }

    @Override
    public NOptional<NArrayElement> asArray() {
        if (this instanceof NArrayElement) {
            return NOptional.of((NArrayElement)((Object)this));
        }
        return NOptional.ofError(() -> this._expected("array"));
    }

    @Override
    public boolean isCustom() {
        return this instanceof NCustomElement;
    }

    @Override
    public boolean isPrimitive() {
        return this.type().isAnyPrimitive();
    }

    @Override
    public boolean isAnyString() {
        return this.type().isAnyStringOrName();
    }

    @Override
    public boolean isStream() {
        return this.type().isAnyStream();
    }

    @Override
    public boolean isNumber() {
        return this.type().isAnyNumber();
    }

    @Override
    public boolean isFloatingNumber() {
        return this.type().isAnyFloatingNumber();
    }

    @Override
    public boolean isOrdinalNumber() {
        return this.type().isAnyOrdinalNumber();
    }

    @Override
    public boolean isNull() {
        NElementType t = this.type();
        return t == NElementType.NULL;
    }

    @Override
    public boolean isString() {
        NElementType t = this.type();
        return t.isAnyString();
    }

    @Override
    public boolean isByte() {
        return this.type() == NElementType.BYTE;
    }

    @Override
    public boolean isInt() {
        NElementType t = this.type();
        return t == NElementType.INT;
    }

    @Override
    public boolean isLong() {
        return this.type() == NElementType.LONG;
    }

    @Override
    public boolean isAnyDate() {
        return this.type().isAnyDate();
    }

    @Override
    public NOptional<NOperatorElement> asOperator() {
        if (this instanceof NOperatorElement) {
            return NOptional.of((NOperatorElement)((Object)this));
        }
        return NOptional.ofEmpty(this._expected("operator"));
    }

    @Override
    public boolean isBinaryInfixOperator() {
        NOptional<NOperatorElement> o = this.asOperator();
        if (o.isPresent()) {
            NOperatorElement oo = o.get();
            return oo.operatorType() == NOperatorType.BINARY_INFIX;
        }
        return false;
    }

    @Override
    public boolean isUnaryPrefixOperator() {
        NOptional<NOperatorElement> o = this.asOperator();
        if (o.isPresent()) {
            NOperatorElement oo = o.get();
            return oo.operatorType() == NOperatorType.UNARY_PREFIX;
        }
        return false;
    }

    @Override
    public boolean isBinaryOperator() {
        NOptional<NOperatorElement> o = this.asOperator();
        if (o.isPresent()) {
            NOperatorElement oo = o.get();
            return oo.operatorType() == NOperatorType.BINARY_INFIX;
        }
        return false;
    }

    @Override
    public boolean isBinaryOperator(NElementType type) {
        NAssert.requireTrue(type != null && type.typeGroup() == NElementTypeGroup.OPERATOR, () -> NMsg.ofC("required operator type, got %s", type));
        NOptional<NOperatorElement> o = this.asOperator();
        if (o.isPresent()) {
            NOperatorElement oo = o.get();
            return oo.operatorType() == NOperatorType.BINARY_INFIX && oo.type() == type;
        }
        return false;
    }

    @Override
    public boolean isLeftNamedBinaryOperator(NElementType type) {
        NOperatorElement oo;
        NAssert.requireTrue(type != null && type.typeGroup() == NElementTypeGroup.OPERATOR, () -> NMsg.ofC("required operator type, got %s", type));
        NOptional<NOperatorElement> o = this.asOperator();
        if (o.isPresent() && (oo = o.get()).operatorType() == NOperatorType.BINARY_INFIX && oo.type() == type && oo.first().isPresent()) {
            NElement f = oo.first().get();
            return f.isName() || f.isString();
        }
        return false;
    }

    @Override
    public boolean isLeftNamedBinaryOperator(NElementType type, String name) {
        NOperatorElement oo;
        NAssert.requireNonNull(name, "name");
        NAssert.requireTrue(type != null && type.typeGroup() == NElementTypeGroup.OPERATOR, () -> NMsg.ofC("required operator type, got %s", type));
        NOptional<NOperatorElement> o = this.asOperator();
        if (o.isPresent() && (oo = o.get()).operatorType() == NOperatorType.BINARY_INFIX && oo.type() == type && oo.first().isPresent()) {
            NElement f = oo.first().get();
            return (f.isName() || f.isString()) && Objects.equals(f.asStringValue().orNull(), name);
        }
        return false;
    }

    @Override
    public boolean isAnyOperator() {
        return this.type().typeGroup() == NElementTypeGroup.OPERATOR;
    }

    @Override
    public boolean isUnaryOperator() {
        NOptional<NOperatorElement> o = this.asOperator();
        if (o.isPresent()) {
            NOperatorElement oo = o.get();
            return oo.operatorType() == NOperatorType.UNARY_PREFIX;
        }
        return false;
    }

    @Override
    public boolean isShort() {
        return this.type() == NElementType.SHORT;
    }

    @Override
    public boolean isFloat() {
        return this.type() == NElementType.FLOAT;
    }

    @Override
    public boolean isDouble() {
        return this.type() == NElementType.DOUBLE;
    }

    @Override
    public boolean isBoolean() {
        return this.type() == NElementType.BOOLEAN;
    }

    @Override
    public boolean isDecimalNumber() {
        return this.type().isAnyDecimalNumber();
    }

    @Override
    public boolean isBigNumber() {
        return this.type().isAnyBigNumber();
    }

    @Override
    public boolean isComplexNumber() {
        return this.type().isAnyComplexNumber();
    }

    @Override
    public boolean isTemporal() {
        return this.type().isAnyTemporal();
    }

    @Override
    public boolean isLocalTemporal() {
        return this.type().isAnyLocalTemporal();
    }

    @Override
    public boolean isNamed() {
        return this.type().isAnyNamed();
    }

    @Override
    public NOptional<NNamedElement> toNamed() {
        if (this instanceof NNamedElement) {
            return NOptional.of((NNamedElement)((Object)this));
        }
        return NOptional.ofEmpty(this._expected("named element"));
    }

    @Override
    public boolean isParametrized() {
        return this.type().isAnyParametrized();
    }

    @Override
    public boolean isObject() {
        NElementType t = this.type();
        return t == NElementType.OBJECT;
    }

    @Override
    public boolean isArray() {
        NElementType t = this.type();
        return t == NElementType.ARRAY;
    }

    @Override
    public boolean isPair() {
        NElementType t = this.type();
        return t == NElementType.PAIR;
    }

    @Override
    public boolean isSimplePair() {
        if (!this.isPair()) {
            return false;
        }
        NElement key = this.asPair().get().key();
        return key.isPrimitive();
    }

    @Override
    public boolean isNamedPair() {
        if (!this.isPair()) {
            return false;
        }
        NElement key = this.asPair().get().key();
        return key.isAnyString();
    }

    @Override
    public NOptional<NPairElement> asNamedPair() {
        NOptional<NPairElement> p;
        NElement key;
        if (this.isPair() && (key = (p = this.asPair()).get().key()).isAnyString()) {
            return p;
        }
        return NOptional.ofEmpty(this._expected("named pair"));
    }

    @Override
    public NOptional<NPairElement> asSimplePair() {
        NOptional<NPairElement> p;
        NElement key;
        if (this.isPair() && (key = (p = this.asPair()).get().key()).isPrimitive()) {
            return p;
        }
        return NOptional.ofEmpty(this._expected("named pair"));
    }

    @Override
    public boolean isNamedPair(String name) {
        if (!this.isPair()) {
            return false;
        }
        NElement key = this.asPair().get().key();
        boolean anyString = key.isAnyString();
        if (anyString) {
            return Objects.equals(name, key.asStringValue().get());
        }
        return false;
    }

    @Override
    public boolean isNamedPair(Predicate<String> nameCondition) {
        if (!this.isPair()) {
            return false;
        }
        NElement key = this.asPair().get().key();
        boolean anyString = key.isAnyString();
        if (anyString) {
            return nameCondition == null || nameCondition.test(key.asStringValue().get());
        }
        return false;
    }

    @Override
    public boolean isParametrizedContainer() {
        return this instanceof NParametrizedContainerElement && ((NParametrizedContainerElement)((Object)this)).isParametrized();
    }

    @Override
    public NOptional<NListContainerElement> toListContainer() {
        if (this.isListContainer()) {
            return this.asListContainer();
        }
        if (this.isNamedPair()) {
            NArrayElementBuilder ab = NElement.ofArrayBuilder();
            ab.name(this.asNamed().get().name().orNull());
            NPairElement pair = this.asPair().get();
            NElement value = pair.value();
            if (value.isListContainer()) {
                NListContainerElement cc = value.asListContainer().get();
                if (cc.isNamed() || cc.isParametrized()) {
                    ab.add(cc);
                } else {
                    ab.addAll(cc.children());
                }
            } else {
                ab.add(value);
            }
            return NOptional.of(ab.build());
        }
        NArrayElementBuilder ab = NElement.ofArrayBuilder();
        ab.add(this);
        return NOptional.of(ab.build());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isBlank() {
        return false;
    }

    @Override
    public NElement describe() {
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNElement that = (AbstractNElement)o;
        return this.type == that.type && Objects.deepEquals(this.annotations, that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.type, Arrays.hashCode(this.annotations));
    }

    @Override
    public NOptional<NPairElement> toNamedPair() {
        switch (this.type) {
            case PAIR: {
                if (this.isNamed()) {
                    return NOptional.of((NPairElement)((Object)this));
                }
                NPairElement u = this.asPair().orNull();
                if (!u.isNamed()) break;
                return NOptional.of(NElement.ofPair(u.name().orNull(), u.value()));
            }
            case NAMED_UPLET: {
                NUpletElement u = this.asUplet().orNull();
                return NOptional.of(NElement.ofPair(u.name().orNull(), (NElement)u.builder().name(null).build()));
            }
            case NAMED_OBJECT: {
                NObjectElement u = this.asObject().orNull();
                if (!u.isNamed() || u.isParametrized()) break;
                return NOptional.of(NElement.ofPair(u.name().orNull(), (NElement)u.builder().name(null).build()));
            }
            case NAMED_ARRAY: {
                NArrayElement u = this.asArray().orNull();
                if (!u.isNamed() || u.isParametrized()) break;
                return NOptional.of(NElement.ofPair(u.name().orNull(), (NElement)u.builder().name(null).build()));
            }
        }
        return NOptional.ofEmpty(this._expected("named pair"));
    }

    @Override
    public NOptional<NUpletElement> toNamedUplet() {
        switch (this.type) {
            case PAIR: {
                NPairElement u = this.asPair().orNull();
                if (!u.isNamed()) break;
                NElement v = u.value();
                return NOptional.of(NElement.ofUplet(u.name().orNull(), v));
            }
            case NAMED_UPLET: {
                return NOptional.of((NUpletElement)((Object)this));
            }
            case NAMED_OBJECT: {
                NObjectElement u = this.asObject().orNull();
                if (u.isParametrized()) break;
                return NOptional.of(NElement.ofUplet(u.name().orNull(), u.children().toArray(new NElement[0])));
            }
            case NAMED_ARRAY: {
                NArrayElement u = this.asArray().orNull();
                if (u.isParametrized()) break;
                return NOptional.of(NElement.ofUplet(u.name().orNull(), u.children().toArray(new NElement[0])));
            }
        }
        return NOptional.ofEmpty(this._expected("named uplet"));
    }

    @Override
    public NOptional<NObjectElement> toNamedObject() {
        switch (this.type) {
            case PAIR: {
                NPairElement u = this.asPair().orNull();
                if (!u.isNamed()) break;
                NElement v = u.value();
                return NOptional.of(NElement.ofObjectBuilder(u.name().orNull()).add(v).build());
            }
            case NAMED_UPLET: {
                NUpletElement u = this.asUplet().orNull();
                return NOptional.of(NElement.ofObjectBuilder(u.name().orNull()).addAll(u.children().toArray(new NElement[0])).build());
            }
            case NAMED_OBJECT: {
                return NOptional.of((NObjectElement)((Object)this));
            }
            case NAMED_ARRAY: {
                NArrayElement u = this.asArray().orNull();
                return NOptional.of(NElement.ofObjectBuilder(u.name().orNull()).addParams(u.params().orNull()).addAll(u.children().toArray(new NElement[0])).build());
            }
        }
        return NOptional.ofEmpty(this._expected("named object"));
    }

    @Override
    public NOptional<NArrayElement> toNamedArray() {
        switch (this.type) {
            case PAIR: {
                NPairElement u = this.asPair().orNull();
                if (!u.isNamed()) break;
                NElement v = u.value();
                return NOptional.of(NElement.ofArrayBuilder(u.name().orNull()).add(v).build());
            }
            case NAMED_UPLET: {
                NUpletElement u = this.asUplet().orNull();
                return NOptional.of(NElement.ofArrayBuilder(u.name().orNull()).addAll(u.children().toArray(new NElement[0])).build());
            }
            case NAMED_OBJECT: {
                NObjectElement u = this.asObject().orNull();
                return NOptional.of(NElement.ofArrayBuilder(u.name().orNull()).addParams(u.params().orNull()).addAll(u.children().toArray(new NElement[0])).build());
            }
            case NAMED_ARRAY: {
                return NOptional.of((NArrayElement)((Object)this));
            }
        }
        return NOptional.ofEmpty(this._expected("named array"));
    }

    @Override
    public NOptional<NObjectElement> toObject() {
        switch (this.type) {
            case PAIR: {
                NPairElement u = this.asPair().orNull();
                if (u.isNamed()) {
                    NElement v = u.value();
                    return NOptional.of(NElement.ofObjectBuilder(u.name().orNull()).add(v).build());
                }
                return NOptional.of(NElement.ofObjectBuilder().add(this).build());
            }
            case NAMED_UPLET: {
                NUpletElement u = this.asUplet().orNull();
                return NOptional.of(NElement.ofObjectBuilder().addAll(u.children().toArray(new NElement[0])).build());
            }
            case UPLET: {
                NUpletElement u = this.asUplet().orNull();
                return NOptional.of(NElement.ofObjectBuilder().addAll(u.children().toArray(new NElement[0])).build());
            }
            case OBJECT: {
                return NOptional.of((NObjectElement)((Object)this));
            }
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: {
                NObjectElement u = this.asObject().orNull();
                return NOptional.of(NElement.ofObjectBuilder().name(u.name().orNull()).addParams(u.params().orNull()).addAll(u.children().toArray(new NElement[0])).build());
            }
            case NAMED_ARRAY: 
            case ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: {
                NArrayElement u = this.asArray().orNull();
                return NOptional.of(NElement.ofObjectBuilder().name(u.name().orNull()).addParams(u.params().orNull()).addAll(u.children().toArray(new NElement[0])).build());
            }
        }
        return NOptional.of(NElement.ofObjectBuilder().add(this).build());
    }

    @Override
    public NOptional<NArrayElement> toArray() {
        switch (this.type) {
            case PAIR: {
                NPairElement u = this.asPair().orNull();
                if (u.isNamed()) {
                    NElement v = u.value();
                    return NOptional.of(NElement.ofArrayBuilder(u.name().orNull()).add(v).build());
                }
                return NOptional.of(NElement.ofArrayBuilder().add(this).build());
            }
            case NAMED_UPLET: {
                NUpletElement u = this.asUplet().orNull();
                return NOptional.of(NElement.ofArrayBuilder().addAll(u.children().toArray(new NElement[0])).build());
            }
            case UPLET: {
                NUpletElement u = this.asUplet().orNull();
                return NOptional.of(NElement.ofArrayBuilder().addAll(u.children().toArray(new NElement[0])).build());
            }
            case NAMED_OBJECT: 
            case OBJECT: 
            case PARAMETRIZED_OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: {
                NObjectElement u = this.asObject().orNull();
                return NOptional.of(NElement.ofArrayBuilder().addParams(u.params().orNull()).addAll(u.children().toArray(new NElement[0])).build());
            }
            case ARRAY: {
                return NOptional.of((NArrayElement)((Object)this));
            }
            case NAMED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: {
                NArrayElement u = this.asArray().orNull();
                return NOptional.of(NElement.ofArrayBuilder().addAll(u.children().toArray(new NElement[0])).build());
            }
        }
        return NOptional.of(NElement.ofArrayBuilder().add(this).build());
    }

    @Override
    public NArrayElement wrapIntoArray() {
        return NElement.ofArray(this);
    }

    @Override
    public NObjectElement wrapIntoObject() {
        return NElement.ofObjectBuilder().add(this).build();
    }

    @Override
    public NUpletElement wrapIntoUplet() {
        return NElement.ofUplet(this);
    }

    @Override
    public NArrayElement wrapIntoNamedArray(String name) {
        return NElement.ofArrayBuilder(name).add(this).build();
    }

    @Override
    public NObjectElement wrapIntoNamedObject(String name) {
        return NElement.ofObjectBuilder(name).add(this).build();
    }

    @Override
    public NUpletElement wrapIntoNamedUplet(String name) {
        return NElement.ofUpletBuilder(name).add(this).build();
    }

    @Override
    public NPairElement wrapIntoNamedPair(String name) {
        return NElement.ofPair(name, (NElement)this);
    }

    @Override
    public NLiteral asLiteral() {
        return new NElementAsLiteral(this);
    }

    @Override
    public NOptional<String> asStringValue() {
        return this.asLiteral().asString();
    }

    @Override
    public NOptional<String> asNameValue() {
        if (this.isName()) {
            return this.asStringValue();
        }
        return NOptional.ofError(() -> NMsg.ofC("unable to cast %s to name: %s", this.type().id(), this));
    }

    @Override
    public NOptional<LocalTime> asLocalTimeValue() {
        return this.asLiteral().asLocalTime();
    }

    @Override
    public NOptional<LocalDate> asLocalDateValue() {
        return this.asLiteral().asLocalDate();
    }

    @Override
    public NOptional<LocalDateTime> asLocalDateTimeValue() {
        return this.asLiteral().asLocalDateTime();
    }

    @Override
    public NOptional<Double> asDoubleValue() {
        return this.asLiteral().asDouble();
    }

    @Override
    public NOptional<Float> asFloatValue() {
        return this.asLiteral().asFloat();
    }

    @Override
    public NOptional<Long> asLongValue() {
        return this.asLiteral().asLong();
    }

    @Override
    public NOptional<Integer> asIntValue() {
        return this.asLiteral().asInt();
    }

    @Override
    public NOptional<Short> asShortValue() {
        return this.asLiteral().asShort();
    }

    @Override
    public NOptional<Byte> asByteValue() {
        return this.asLiteral().asByte();
    }

    @Override
    public NOptional<NFloatComplex> asFloatComplexValue() {
        return this.asLiteral().asFloatComplex();
    }

    @Override
    public NOptional<NDoubleComplex> asDoubleComplexValue() {
        return this.asLiteral().asDoubleComplex();
    }

    @Override
    public NOptional<NBigComplex> asBigComplexValue() {
        return this.asLiteral().asBigComplex();
    }

    @Override
    public NOptional<Instant> asInstantValue() {
        return this.asLiteral().asInstant();
    }

    @Override
    public NOptional<Character> asCharValue() {
        return this.asLiteral().asChar();
    }

    @Override
    public NOptional<Boolean> asBooleanValue() {
        return this.asLiteral().asBoolean();
    }

    @Override
    public NOptional<BigDecimal> asBigDecimalValue() {
        return this.asLiteral().asBigDecimal();
    }

    @Override
    public NOptional<BigInteger> asBigIntValue() {
        return this.asLiteral().asBigInt();
    }

    @Override
    public NOptional<Number> asNumberValue() {
        return this.asLiteral().asNumber();
    }

    @Override
    public NOptional<Temporal> asTemporalValue() {
        return NOptional.ofError(() -> this._expected("temporal"));
    }

    @Override
    public NOptional<NElement> asNumberType(NElementType elemType) {
        return NOptional.ofEmpty(NMsg.ofC("not a number %s", this));
    }

    @Override
    public NElement[] transform(NElementTransform transform) {
        return NElementTransformHelper.transform(this, transform);
    }
}

