/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementCommentsImpl;
import net.thevpc.nuts.util.NStringBuilder;

public class NElementCommentsBuilderImpl {
    private List<NElementComment> leadingComments = new ArrayList<NElementComment>();
    private List<NElementComment> trailingComments = new ArrayList<NElementComment>();

    private static NElementComment[] _trim(NElementComment[] all) {
        ArrayList<NElementComment> ok = new ArrayList<NElementComment>();
        if (all != null) {
            for (NElementComment a : all) {
                if (a == null || a.text().isEmpty()) continue;
                ok.add(a);
            }
        }
        return ok.toArray(new NElementComment[0]);
    }

    public NElementCommentsBuilderImpl() {
    }

    public NElementCommentsBuilderImpl(NElementComment[] leadingComments, NElementComment[] trailingComments) {
        this.leadingComments.addAll(Arrays.asList(NElementCommentsBuilderImpl._trim(leadingComments)));
        this.trailingComments.addAll(Arrays.asList(NElementCommentsBuilderImpl._trim(trailingComments)));
    }

    public NElementCommentsBuilderImpl addLeading(NElementComment ... leadingComments) {
        this.leadingComments.addAll(Arrays.asList(NElementCommentsBuilderImpl._trim(leadingComments)));
        return this;
    }

    public NElementCommentsBuilderImpl addTrailing(NElementComment ... trailingComments) {
        this.trailingComments.addAll(Arrays.asList(NElementCommentsBuilderImpl._trim(trailingComments)));
        return this;
    }

    public NElementCommentsBuilderImpl removeLeadingCommentAt(int index) {
        if (index >= 0 && index < this.leadingComments.size()) {
            this.leadingComments.remove(index);
        }
        return this;
    }

    public NElementCommentsBuilderImpl removeLeading(NElementComment comment) {
        Iterator<NElementComment> iterator = this.leadingComments.iterator();
        while (iterator.hasNext()) {
            NElementComment currentComment = iterator.next();
            if (!Objects.equals(currentComment, comment)) continue;
            iterator.remove();
            break;
        }
        return this;
    }

    public NElementCommentsBuilderImpl removeTrailingCommentAt(int index) {
        if (index >= 0 && index < this.trailingComments.size()) {
            this.trailingComments.remove(index);
        }
        return this;
    }

    public NElementCommentsBuilderImpl removeTrailingComment(NElementComment comment) {
        Iterator<NElementComment> iterator = this.trailingComments.iterator();
        while (iterator.hasNext()) {
            NElementComment currentComment = iterator.next();
            if (!Objects.equals(currentComment, comment)) continue;
            iterator.remove();
            break;
        }
        return this;
    }

    public String toString() {
        NStringBuilder sb = new NStringBuilder();
        for (NElementComment leadingComment : this.leadingComments) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            sb.append(leadingComment);
        }
        for (NElementComment ec : this.trailingComments) {
            sb.append("\n");
            sb.append(ec);
        }
        return sb.toString();
    }

    public List<NElementComment> trailingComments() {
        return Collections.unmodifiableList(this.trailingComments);
    }

    public List<NElementComment> leadingComments() {
        return Collections.unmodifiableList(this.leadingComments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NElementCommentsBuilderImpl that = (NElementCommentsBuilderImpl)o;
        return Objects.deepEquals(this.leadingComments, that.leadingComments) && Objects.deepEquals(this.trailingComments, that.trailingComments);
    }

    public int hashCode() {
        return Objects.hash(Objects.hashCode(this.leadingComments), Objects.hashCode(this.trailingComments));
    }

    public boolean isBlank() {
        return this.leadingComments.isEmpty() && this.trailingComments.isEmpty();
    }

    public NElementComments build() {
        return new NElementCommentsImpl(this.leadingComments.toArray(new NElementComment[0]), this.trailingComments.toArray(new NElementComment[0]));
    }

    public NElementCommentsBuilderImpl clear() {
        this.leadingComments.clear();
        this.trailingComments.clear();
        return this;
    }

    public NElementCommentsBuilderImpl addComments(NElementComments comments) {
        if (comments != null) {
            for (NElementComment e : comments.leadingComments()) {
                this.addLeading(e);
            }
            for (NElementComment e : comments.trailingComments()) {
                this.addTrailing(e);
            }
        }
        return this;
    }
}

