/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.builder;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.function.Consumer;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementCommentType;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NNumberElement;
import net.thevpc.nuts.elem.NNumberLayout;
import net.thevpc.nuts.elem.NPrimitiveElement;
import net.thevpc.nuts.elem.NPrimitiveElementBuilder;
import net.thevpc.nuts.math.NBigComplex;
import net.thevpc.nuts.math.NDoubleComplex;
import net.thevpc.nuts.math.NFloatComplex;
import net.thevpc.nuts.runtime.standalone.elem.AbstractNElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNNumberElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNPrimitiveElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNStringElement;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NMapStrategy;

public class DefaultNPrimitiveElementBuilder
extends AbstractNElementBuilder
implements NPrimitiveElementBuilder {
    private Object value;
    private NNumberLayout numberLayout;
    private String numberSuffix;
    private NElementType type = NElementType.NULL;

    @Override
    public NPrimitiveElementBuilder removeAnnotation(NElementAnnotation annotation) {
        super.removeAnnotation(annotation);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder copyFrom(NElementBuilder other) {
        this.copyFrom(other, NMapStrategy.ANY);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder copyFrom(NElement other) {
        this.copyFrom(other, NMapStrategy.ANY);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder copyFrom(NElementBuilder other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        super.copyFrom(other, strategy);
        if (other instanceof NPrimitiveElementBuilder) {
            NPrimitiveElementBuilder from = (NPrimitiveElementBuilder)other;
            this.type = from.type();
            this.value = from.value();
            this.numberLayout = from.numberLayout();
            this.numberSuffix = from.numberSuffix();
        }
        return this;
    }

    @Override
    public NPrimitiveElementBuilder copyFrom(NElement other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        super.copyFrom(other, strategy);
        if (other instanceof NPrimitiveElement) {
            NPrimitiveElement from = (NPrimitiveElement)other;
            this.type = from.type();
            this.value = from.value();
            if (other instanceof NNumberElement) {
                NNumberElement nfrom = (NNumberElement)other;
                this.numberLayout = nfrom.numberLayout();
                this.numberSuffix = nfrom.numberSuffix();
            }
        }
        return this;
    }

    @Override
    public NNumberLayout numberLayout() {
        return this.numberLayout;
    }

    @Override
    public NPrimitiveElementBuilder numberLayout(NNumberLayout numberLayout) {
        this.numberLayout = numberLayout;
        return this;
    }

    @Override
    public String numberSuffix() {
        return this.numberSuffix;
    }

    @Override
    public NPrimitiveElementBuilder numberSuffix(String numberSuffix) {
        this.numberSuffix = numberSuffix;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setValue(Object value) {
        return this.value(value);
    }

    @Override
    public NPrimitiveElementBuilder value(Object value) {
        if (value == null) {
            this.value = null;
            this.type = NElementType.NULL;
        } else {
            switch (value.getClass().getName()) {
                case "java.lang.String": {
                    this.setDoubleQuotedString((String)value);
                    break;
                }
                case "java.lang.Boolean": 
                case "boolean": {
                    this.setBoolean((boolean)((Boolean)value));
                    break;
                }
                case "java.lang.Byte": 
                case "byte": {
                    this.setByte((byte)((Byte)value));
                    break;
                }
                case "java.lang.Short": 
                case "short": {
                    this.setShort((short)((Short)value));
                    break;
                }
                case "java.lang.Character": 
                case "char": {
                    this.setChar(((Character)value).charValue());
                    break;
                }
                case "java.lang.Integer": 
                case "int": {
                    this.setInt((int)((Integer)value));
                    break;
                }
                case "java.lang.Long": 
                case "long": {
                    this.setLong((long)((Long)value));
                    break;
                }
                case "java.lang.Float": 
                case "float": {
                    this.setFloat(Float.valueOf(((Float)value).floatValue()));
                    break;
                }
                case "java.lang.Double": 
                case "double": {
                    this.setDouble((double)((Double)value));
                    break;
                }
                case "java.math.BigInteger": {
                    this.setBigInt((BigInteger)value);
                    break;
                }
                case "java.math.BigDecimal": {
                    this.setBigDecimal((BigDecimal)value);
                    break;
                }
                case "java.time.Instant": {
                    this.setInstant((Instant)value);
                    break;
                }
                case "java.time.LocalDate": {
                    this.setLocalDate((LocalDate)value);
                    break;
                }
                case "java.time.LocalTime": {
                    this.setLocalTime((LocalTime)value);
                    break;
                }
                case "java.time.LocalDateTime": {
                    this.setLocalDateTime((LocalDateTime)value);
                    break;
                }
                default: {
                    if (value instanceof NDoubleComplex) {
                        this.setDoubleComplex((NDoubleComplex)value);
                        break;
                    }
                    if (value instanceof NFloatComplex) {
                        this.setFloatComplex((NFloatComplex)value);
                        break;
                    }
                    if (value instanceof NBigComplex) {
                        this.setBigComplex((NBigComplex)value);
                        break;
                    }
                    throw new NIllegalArgumentException(NMsg.ofC("Unsupported type: %s", value.getClass().getName()));
                }
            }
        }
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setInstant(Instant value) {
        if (value == null) {
            return this.setNull();
        }
        this.value = value;
        this.type = NElementType.INSTANT;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setLocalDate(LocalDate value) {
        if (value == null) {
            return this.setNull();
        }
        this.value = value;
        this.type = NElementType.LOCAL_DATE;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setLocalDateTime(LocalDateTime value) {
        if (value == null) {
            return this.setNull();
        }
        this.value = value;
        this.type = NElementType.LOCAL_DATETIME;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setLocalTime(LocalTime value) {
        if (value == null) {
            return this.setNull();
        }
        this.value = value;
        this.type = NElementType.LOCAL_TIME;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setString(String value) {
        if (value == null) {
            return this.setNull();
        }
        NElementType newType = this.type;
        if (newType == null || !newType.isAnyString()) {
            newType = NElementType.DOUBLE_QUOTED_STRING;
        }
        this.value = value;
        this.type = newType;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setString(String value, NElementType stringLayout) {
        if (stringLayout == null) {
            NElementType newType = this.type;
            if (newType == null || !newType.isAnyString()) {
                newType = NElementType.DOUBLE_QUOTED_STRING;
            }
            stringLayout = newType;
        }
        NAssert.requireTrue(stringLayout.isAnyString(), "string : " + stringLayout.id());
        if (value == null) {
            this.setNull();
        } else {
            this.value = value;
            this.type = stringLayout;
            this.numberLayout = null;
            this.numberSuffix = null;
        }
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setBoolean(Boolean value) {
        if (value == null) {
            return this.setNull();
        }
        this.value = value;
        this.type = NElementType.BOOLEAN;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setBoolean(boolean value) {
        this.value = value;
        this.type = NElementType.BOOLEAN;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setSingleQuotedString(String value) {
        return this.setString(value, NElementType.SINGLE_QUOTED_STRING);
    }

    @Override
    public NPrimitiveElementBuilder setDoubleQuotedString(String value) {
        return this.setString(value, NElementType.DOUBLE_QUOTED_STRING);
    }

    @Override
    public NPrimitiveElementBuilder setAntiQuotedString(String value) {
        return this.setString(value, NElementType.ANTI_QUOTED_STRING);
    }

    @Override
    public NPrimitiveElementBuilder setTripleSingleQuotedString(String value) {
        return this.setString(value, NElementType.TRIPLE_SINGLE_QUOTED_STRING);
    }

    @Override
    public NPrimitiveElementBuilder setTripleDoubleQuotedString(String value) {
        return this.setString(value, NElementType.TRIPLE_DOUBLE_QUOTED_STRING);
    }

    @Override
    public NPrimitiveElementBuilder setTripleAntiQuotedString(String value) {
        return this.setString(value, NElementType.TRIPLE_ANTI_QUOTED_STRING);
    }

    @Override
    public NPrimitiveElementBuilder setLineString(String value) {
        return this.setString(value, NElementType.LINE_STRING);
    }

    @Override
    public NPrimitiveElementBuilder setInt(Integer value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.INT;
        this.value = value;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setLong(Long value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.LONG;
        this.value = value;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setNull() {
        this.value = null;
        this.type = NElementType.NULL;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setByte(Byte value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.BYTE;
        this.value = value;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setShort(Short value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.SHORT;
        this.value = value;
        this.numberLayout = NNumberLayout.DECIMAL;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setChar(char value) {
        this.type = NElementType.CHAR;
        this.value = Character.valueOf(value);
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setChar(Character value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.CHAR;
        this.value = value;
        this.numberLayout = null;
        this.numberSuffix = null;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setShort(short value) {
        this.type = NElementType.SHORT;
        this.value = value;
        this.numberLayout = NNumberLayout.DECIMAL;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setDouble(double value) {
        this.type = NElementType.DOUBLE;
        this.value = value;
        this.numberLayout = NNumberLayout.DECIMAL;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setFloat(Float value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.FLOAT;
        this.value = value;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setDouble(Double value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.DOUBLE;
        this.value = value;
        this.numberLayout = NNumberLayout.DECIMAL;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setBigInt(BigInteger value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.BIG_INT;
        this.value = value;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setBigDecimal(BigDecimal value) {
        if (value == null) {
            return this.setNull();
        }
        this.type = NElementType.BIG_DECIMAL;
        this.value = value;
        this.numberLayout = NNumberLayout.DECIMAL;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setInt(int value) {
        this.type = NElementType.INT;
        this.value = value;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setByte(byte value) {
        this.type = NElementType.BYTE;
        this.value = value;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setDoubleComplex(NDoubleComplex value) {
        if (value == null) {
            return this.setNull();
        }
        this.value = value;
        this.type = NElementType.DOUBLE_COMPLEX;
        this.numberLayout = NNumberLayout.DECIMAL;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setFloatComplex(NFloatComplex value) {
        if (value == null) {
            return this.setNull();
        }
        this.value = value;
        this.type = NElementType.FLOAT_COMPLEX;
        this.numberLayout = NNumberLayout.DECIMAL;
        return this;
    }

    @Override
    public NPrimitiveElementBuilder setBigComplex(NBigComplex value) {
        if (value == null) {
            return this.setNull();
        }
        this.value = value;
        this.type = NElementType.BIG_COMPLEX;
        this.numberLayout = NNumberLayout.DECIMAL;
        return this;
    }

    @Override
    public NPrimitiveElement build() {
        if (this.type().isAnyNumber()) {
            return new DefaultNNumberElement(this.type, (Number)this.value, this.numberLayout(), this.numberSuffix(), this.annotations().toArray(new NElementAnnotation[0]), this.comments());
        }
        if (this.type().isAnyStringOrName()) {
            return new DefaultNStringElement(this.type, (String)this.value, this.annotations().toArray(new NElementAnnotation[0]), this.comments());
        }
        return new DefaultNPrimitiveElement(this.type, this.value, this.annotations().toArray(new NElementAnnotation[0]), this.comments());
    }

    @Override
    public NElementType type() {
        return this.type;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public NPrimitiveElementBuilder addLeadingComment(NElementCommentType type, String text) {
        super.addLeadingComment(type, text);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addTrailingComment(NElementCommentType type, String text) {
        super.addTrailingComment(type, text);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addLeadingComment(NElementComment comment) {
        super.addLeadingComment(comment);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addLeadingComments(NElementComment ... comments) {
        super.addLeadingComments(comments);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addTrailingComment(NElementComment comment) {
        super.addTrailingComment(comment);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addTrailingComments(NElementComment ... comments) {
        super.addTrailingComments(comments);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder removeTrailingCommentAt(int index) {
        super.removeTrailingCommentAt(index);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder removeLeadingCommentAt(int index) {
        super.removeLeadingCommentAt(index);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder removeTrailingComment(NElementComment comment) {
        super.removeTrailingComment(comment);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder removeLeadingComment(NElementComment comment) {
        super.removeLeadingComment(comment);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addComments(NElementComments comments) {
        super.addComments(comments);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addAnnotations(List<NElementAnnotation> annotations) {
        super.addAnnotations(annotations);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addAnnotation(String name, NElement ... args) {
        super.addAnnotation(name, args);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addAnnotation(NElementAnnotation annotation) {
        super.addAnnotation(annotation);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder addAnnotationAt(int index, NElementAnnotation annotation) {
        super.addAnnotationAt(index, annotation);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder removeAnnotationAt(int index) {
        super.removeAnnotationAt(index);
        return this;
    }

    @Override
    public NPrimitiveElementBuilder clearAnnotations() {
        super.clearAnnotations();
        return this;
    }

    @Override
    public NPrimitiveElementBuilder clearComments() {
        super.clearComments();
        return this;
    }

    @Override
    public NPrimitiveElementBuilder copyFrom(NPrimitiveElement element) {
        if (element != null) {
            this.addAnnotations((List)element.annotations());
            this.addComments(element.comments());
            this.value = element.value();
            this.type = element.type();
            if (element instanceof NNumberElement) {
                NNumberElement ne = (NNumberElement)element;
                this.numberLayout(ne.numberLayout());
                this.numberSuffix(ne.numberSuffix());
            }
        }
        return this;
    }

    @Override
    public NPrimitiveElementBuilder doWith(Consumer<NPrimitiveElementBuilder> con) {
        if (con != null) {
            con.accept(this);
        }
        return this;
    }
}

