/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.builder;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementCommentType;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NOperatorElement;
import net.thevpc.nuts.elem.NOperatorElementBuilder;
import net.thevpc.nuts.elem.NOperatorType;
import net.thevpc.nuts.runtime.standalone.elem.AbstractNElementBuilder;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNOperatorElement;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NMapStrategy;
import net.thevpc.nuts.util.NOptional;

public class DefaultNOperatorElementBuilder
extends AbstractNElementBuilder
implements NOperatorElementBuilder {
    private NElementType operator;
    private NOperatorType operatorType;
    private NElement first;
    private NElement second;

    @Override
    public NOperatorElementBuilder operator(NElementType operator) {
        if (operator != null) {
            NAssert.requireTrue(operator.isAnyOp(), "operator");
        }
        this.operator = operator;
        return this;
    }

    @Override
    public NOperatorElementBuilder removeAnnotation(NElementAnnotation annotation) {
        super.removeAnnotation(annotation);
        return this;
    }

    @Override
    public NOperatorType operatorType() {
        return this.operatorType;
    }

    @Override
    public NOperatorElementBuilder operatorType(NOperatorType operatorType) {
        this.operatorType = operatorType;
        return this;
    }

    @Override
    public NOperatorElementBuilder first(NElement first) {
        this.first = first;
        return this;
    }

    @Override
    public NOperatorElementBuilder second(NElement second) {
        this.second = second;
        return this;
    }

    @Override
    public NElementType type() {
        return null;
    }

    @Override
    public NElementType operator() {
        return this.operator;
    }

    @Override
    public NOptional<NElement> first() {
        return NOptional.ofNamed(this.first, NMsg.ofC("first operand of %s", this.operator()));
    }

    @Override
    public NOptional<NElement> second() {
        return NOptional.ofNamed(this.second, NMsg.ofC("second operand of %s", this.operator()));
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean compact) {
        return this.build().toString(compact);
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DefaultNOperatorElementBuilder that = (DefaultNOperatorElementBuilder)object;
        return this.operator == that.operator && Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operator, this.first, this.second);
    }

    @Override
    public NOperatorElement build() {
        NAssert.requireNonNull(this.operator, "operator");
        NAssert.requireNonNull(this.first, "first");
        if (this.operatorType == null) {
            this.operatorType = this.second == null ? NOperatorType.UNARY_PREFIX : NOperatorType.BINARY_INFIX;
        }
        if (this.operatorType == NOperatorType.BINARY_INFIX && this.second == null) {
            NAssert.requireNonNull(this.second, "second");
        }
        return new DefaultNOperatorElement(this.operator, this.operatorType, this.first, this.second, this.annotations().toArray(new NElementAnnotation[0]), this.comments());
    }

    @Override
    public NOperatorElementBuilder copyFrom(NOperatorElementBuilder element) {
        if (element != null) {
            super.copyFrom(element);
            this.operator = element.operator();
            this.operatorType = element.operatorType();
            this.first = element.first().orNull();
            this.second = element.second().orNull();
        }
        return this;
    }

    @Override
    public NOperatorElementBuilder copyFrom(NElementBuilder other) {
        if (other instanceof NOperatorElementBuilder) {
            return this.copyFrom((NOperatorElementBuilder)other);
        }
        return (NOperatorElementBuilder)super.copyFrom(other);
    }

    @Override
    public NOperatorElementBuilder doWith(Consumer<NOperatorElementBuilder> con) {
        con.accept(this);
        return this;
    }

    @Override
    public NOperatorElementBuilder addLeadingComment(NElementCommentType type, String text) {
        return (NOperatorElementBuilder)super.addLeadingComment(type, text);
    }

    @Override
    public NOperatorElementBuilder addTrailingComment(NElementCommentType type, String text) {
        return (NOperatorElementBuilder)super.addTrailingComment(type, text);
    }

    @Override
    public NOperatorElementBuilder addLeadingComment(NElementComment comment) {
        return (NOperatorElementBuilder)super.addLeadingComment(comment);
    }

    @Override
    public NOperatorElementBuilder addLeadingComments(NElementComment ... comments) {
        return (NOperatorElementBuilder)super.addLeadingComments(comments);
    }

    @Override
    public NOperatorElementBuilder addTrailingComment(NElementComment comment) {
        return (NOperatorElementBuilder)super.addTrailingComment(comment);
    }

    @Override
    public NOperatorElementBuilder addTrailingComments(NElementComment ... comments) {
        return (NOperatorElementBuilder)super.addTrailingComments(comments);
    }

    @Override
    public NOperatorElementBuilder clearComments() {
        return (NOperatorElementBuilder)super.clearComments();
    }

    @Override
    public NOperatorElementBuilder removeTrailingCommentAt(int index) {
        return (NOperatorElementBuilder)super.removeTrailingCommentAt(index);
    }

    @Override
    public NOperatorElementBuilder removeLeadingCommentAt(int index) {
        return (NOperatorElementBuilder)super.removeLeadingCommentAt(index);
    }

    @Override
    public NOperatorElementBuilder removeTrailingComment(NElementComment comment) {
        return (NOperatorElementBuilder)super.removeTrailingComment(comment);
    }

    @Override
    public NOperatorElementBuilder removeLeadingComment(NElementComment comment) {
        return (NOperatorElementBuilder)super.removeLeadingComment(comment);
    }

    @Override
    public NOperatorElementBuilder addComments(NElementComments comments) {
        return (NOperatorElementBuilder)super.addComments(comments);
    }

    @Override
    public NOperatorElementBuilder addAnnotations(List<NElementAnnotation> annotations) {
        return (NOperatorElementBuilder)super.addAnnotations(annotations);
    }

    @Override
    public NOperatorElementBuilder addAnnotation(String name, NElement ... args) {
        return (NOperatorElementBuilder)super.addAnnotation(name, args);
    }

    @Override
    public NOperatorElementBuilder addAnnotation(NElementAnnotation annotation) {
        return (NOperatorElementBuilder)super.addAnnotation(annotation);
    }

    @Override
    public NOperatorElementBuilder addAnnotationAt(int index, NElementAnnotation annotation) {
        return (NOperatorElementBuilder)super.addAnnotationAt(index, annotation);
    }

    @Override
    public NOperatorElementBuilder removeAnnotationAt(int index) {
        return (NOperatorElementBuilder)super.removeAnnotationAt(index);
    }

    @Override
    public NOperatorElementBuilder clearAnnotations() {
        return (NOperatorElementBuilder)super.clearAnnotations();
    }

    @Override
    public NOperatorElementBuilder copyFrom(NElementBuilder other, NMapStrategy strategy) {
        return (NOperatorElementBuilder)super.copyFrom(other, strategy);
    }

    @Override
    public NOperatorElementBuilder copyFrom(NElement other, NMapStrategy strategy) {
        return (NOperatorElementBuilder)super.copyFrom(other, strategy);
    }

    @Override
    public NOperatorElementBuilder copyFrom(NElement other) {
        return (NOperatorElementBuilder)super.copyFrom(other);
    }
}

