/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.runtime.standalone.elem.NElementFactoryService;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNArrayElement;
import net.thevpc.nuts.runtime.standalone.elem.parser.mapperstore.DefaultElementMapperStore;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class DefaultNElementFactoryService
implements NElementFactoryService {
    private NReflectRepository typesRepository;
    private final NWorkspace workspace;

    public DefaultNElementFactoryService(NWorkspace workspace) {
        this.typesRepository = NWorkspaceUtils.of(workspace).getReflectRepository();
        this.workspace = workspace;
    }

    protected Object createObject(NElement o, Type to, NElementFactoryContext context, boolean defaultOnly) {
        if (o == null || o.type() == NElementType.NULL) {
            return DefaultElementMapperStore.F_NULL.createObject(o, to, context);
        }
        if (to == null) {
            NElementMapper f = context.getMapper(o, defaultOnly);
            if (f == null) {
                throw new NUnsupportedEnumException(o.type());
            }
            return f.createObject(o, to, context);
        }
        NElementMapper f = context.getMapper(to, defaultOnly);
        return f.createObject(o, to, context);
    }

    @Override
    public Object createObject(NElement o, Type to, NElementFactoryContext context) {
        return this.createObject(o, to, context, false);
    }

    @Override
    public Object defaultCreateObject(NElement o, Type to, NElementFactoryContext context) {
        return this.createObject(o, to, context, true);
    }

    protected Object destruct(Object o, Type expectedType, NElementFactoryContext context, boolean defaultOnly) {
        if (o == null) {
            return null;
        }
        if (expectedType == null) {
            expectedType = o.getClass();
        }
        if (context.isIndestructibleObject(o)) {
            return o;
        }
        return context.getMapper(expectedType, defaultOnly).destruct(o, expectedType, context);
    }

    @Override
    public Object destruct(Object o, Type expectedType, NElementFactoryContext context) {
        return this.destruct(o, expectedType, context, false);
    }

    @Override
    public Object defaultDestruct(Object o, Type expectedType, NElementFactoryContext context) {
        return this.destruct(o, expectedType, context, true);
    }

    protected NElement createElement(Object o, Type expectedType, NElementFactoryContext context, boolean defaultOnly) {
        if (o == null) {
            return NElement.ofNull();
        }
        if (expectedType == null) {
            expectedType = o.getClass();
        }
        if (context.isIndestructibleObject(o)) {
            return NElement.ofCustom(o);
        }
        NElementMapper<Object> mapper = context.getMapper(expectedType, defaultOnly);
        return mapper.createElement(o, expectedType, context);
    }

    @Override
    public NElement createElement(Object o, Type expectedType, NElementFactoryContext context) {
        return this.createElement(o, expectedType, context, false);
    }

    @Override
    public NElement defaultCreateElement(Object o, Type expectedType, NElementFactoryContext context) {
        return this.createElement(o, expectedType, context, true);
    }

    public NReflectRepository getTypesRepository() {
        return this.typesRepository;
    }

    public static List<Object> _destructArray1(Object array, NElementFactoryContext context) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> preloaded = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                preloaded.add(context.destruct(Array.get(array, i), null));
            }
            return preloaded;
        }
        return Arrays.stream((Object[])array).map(x -> context.destruct(x, null)).collect(Collectors.toList());
    }

    public static NArrayElement _createArray1(Object array, NElementFactoryContext context) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<NElement> preloaded = new ArrayList<NElement>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                preloaded.add(context.createElement(Array.get(array, i)));
            }
            return new DefaultNArrayElement(null, null, preloaded, new NElementAnnotation[0], null);
        }
        return new DefaultNArrayElement(null, null, Arrays.stream((Object[])array).map(x -> context.createElement(x)).collect(Collectors.toList()), new NElementAnnotation[0], null);
    }
}

