/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementComment;
import net.thevpc.nuts.elem.NElementCommentType;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.runtime.standalone.elem.builder.NElementCommentsBuilderImpl;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementAnnotationImpl;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementCommentImpl;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NMapStrategy;

public abstract class AbstractNElementBuilder
implements NElementBuilder {
    private NElementCommentsBuilderImpl comments = new NElementCommentsBuilderImpl();
    private final List<NElementAnnotation> annotations = new ArrayList<NElementAnnotation>();

    @Override
    public boolean isCustomTree() {
        if (this.annotations != null) {
            for (NElementAnnotation annotation : this.annotations) {
                if (!annotation.isCustomTree()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NElementBuilder addLeadingComment(NElementCommentType type, String text) {
        NAssert.requireNonNull(type, "comment type");
        return this.addLeadingComment(new NElementCommentImpl(type, text));
    }

    @Override
    public NElementBuilder addTrailingComment(NElementCommentType type, String text) {
        NAssert.requireNonNull(type, "comment type");
        return this.addTrailingComment(new NElementCommentImpl(type, text));
    }

    @Override
    public NElementBuilder addLeadingComment(NElementComment comment) {
        this.comments.addLeading(comment);
        return this;
    }

    @Override
    public NElementBuilder addLeadingComments(NElementComment ... comments) {
        this.comments.addLeading(comments);
        return this;
    }

    @Override
    public NElementBuilder addTrailingComment(NElementComment comment) {
        this.comments.addTrailing(comment);
        return this;
    }

    @Override
    public NElementBuilder addTrailingComments(NElementComment ... comments) {
        this.comments.addTrailing(comments);
        return this;
    }

    @Override
    public NElementComments comments() {
        return this.comments.build();
    }

    @Override
    public NElementBuilder clearComments() {
        this.comments.clear();
        return this;
    }

    @Override
    public NElementBuilder removeTrailingCommentAt(int index) {
        this.comments.removeTrailingCommentAt(index);
        return this;
    }

    @Override
    public NElementBuilder removeLeadingCommentAt(int index) {
        this.comments.removeLeadingCommentAt(index);
        return this;
    }

    @Override
    public NElementBuilder removeTrailingComment(NElementComment comment) {
        this.comments.removeTrailingComment(comment);
        return this;
    }

    @Override
    public NElementBuilder removeLeadingComment(NElementComment comment) {
        this.comments.removeLeading(comment);
        return this;
    }

    @Override
    public List<NElementComment> trailingComments() {
        return this.comments.trailingComments();
    }

    @Override
    public List<NElementComment> leadingComments() {
        return this.comments.leadingComments();
    }

    @Override
    public NElementBuilder addComments(NElementComments comments) {
        this.comments.addComments(comments);
        return this;
    }

    @Override
    public NElementBuilder addAnnotations(List<NElementAnnotation> annotations) {
        if (annotations != null) {
            for (NElementAnnotation a : annotations) {
                if (a == null) continue;
                this.annotations.add(a);
            }
        }
        return this;
    }

    @Override
    public NElementBuilder addAnnotation(String name, NElement ... args) {
        return this.addAnnotation(new NElementAnnotationImpl(name, args));
    }

    @Override
    public NElementBuilder addAnnotation(NElementAnnotation annotation) {
        if (annotation != null) {
            this.annotations.add(annotation);
        }
        return this;
    }

    @Override
    public NElementBuilder addAnnotationAt(int index, NElementAnnotation annotation) {
        if (annotation != null) {
            this.annotations.add(index, annotation);
        }
        return this;
    }

    @Override
    public NElementBuilder removeAnnotation(NElementAnnotation annotation) {
        this.annotations.remove(annotation);
        return this;
    }

    @Override
    public NElementBuilder removeAnnotationAt(int index) {
        this.annotations.remove(index);
        return this;
    }

    @Override
    public NElementBuilder clearAnnotations() {
        this.annotations.clear();
        return this;
    }

    @Override
    public List<NElementAnnotation> annotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    @Override
    public NElementBuilder copyFrom(NElementBuilder other) {
        this.copyFrom(other, NMapStrategy.ANY);
        return this;
    }

    @Override
    public NElementBuilder copyFrom(NElement other) {
        if (other != null) {
            this.copyFrom(other.builder());
        }
        return this;
    }

    @Override
    public NElementBuilder copyFrom(NElementBuilder other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        this.comments.addLeading(other.leadingComments().toArray(new NElementComment[0]));
        this.comments.addTrailing(other.trailingComments().toArray(new NElementComment[0]));
        this.annotations.addAll(other.annotations());
        return this;
    }

    @Override
    public NElementBuilder copyFrom(NElement other, NMapStrategy strategy) {
        if (other == null) {
            return this;
        }
        NElementComments cmt = other.comments();
        this.comments.addLeading(cmt.leadingComments().toArray(new NElementComment[0]));
        this.comments.addTrailing(cmt.trailingComments().toArray(new NElementComment[0]));
        this.annotations.addAll(other.annotations());
        return this;
    }
}

