/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyBuilder;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorBuilder;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NDescriptorProperty;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorProperty;
import net.thevpc.nuts.runtime.standalone.DefaultNEnvConditionBuilder;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.MapToFunction;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.DefaultNProperties;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStringUtils;

public class NDescriptorUtils {
    public static Map<String, NDescriptorProperty> getPropertiesMap2(List<NDescriptorProperty> list) {
        LinkedHashMap<String, NDescriptorProperty> m = new LinkedHashMap<String, NDescriptorProperty>();
        if (list != null) {
            for (NDescriptorProperty property : list) {
                m.put(property.getName(), property);
            }
        }
        return m;
    }

    public static Map<String, String> getPropertiesMap(List<NDescriptorProperty> list) {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (list != null) {
            for (NDescriptorProperty property : list) {
                if (NBlankable.isBlank(property.getCondition())) {
                    m.put(property.getName(), property.getValue().asString().orNull());
                    continue;
                }
                throw new NIllegalArgumentException(NMsg.ofPlain("unexpected properties with conditions. probably a bug"));
            }
        }
        return m;
    }

    public static NDescriptor checkDescriptor(NDescriptor nutsDescriptor) {
        NVersion version;
        NId id = nutsDescriptor.getId();
        String groupId = id == null ? null : id.getGroupId();
        String artifactId = id == null ? null : id.getArtifactId();
        NVersion nVersion = version = id == null ? null : id.getVersion();
        if (groupId == null || artifactId == null || NBlankable.isBlank(version)) {
            NSession session = NSession.of();
            switch (session.getConfirm().orDefault()) {
                case ASK: 
                case ERROR: {
                    if (groupId == null) {
                        groupId = NAsk.of().forString(NMsg.ofPlain("group id")).setDefaultValue(groupId).setHintMessage(NBlankable.isBlank(groupId) ? null : NMsg.ofPlain(groupId)).getValue();
                    }
                    if (artifactId == null) {
                        artifactId = NAsk.of().forString(NMsg.ofPlain("artifact id")).setDefaultValue(artifactId).setHintMessage(NBlankable.isBlank(artifactId) ? null : NMsg.ofPlain(artifactId)).getValue();
                    }
                    if (!NBlankable.isBlank(version)) break;
                    String ov = version == null ? null : version.getValue();
                    String v = NAsk.of().forString(NMsg.ofPlain("version")).setDefaultValue(ov).setHintMessage(NBlankable.isBlank(ov) ? null : NMsg.ofPlain(ov)).getValue();
                    version = NVersion.get(v).get();
                    break;
                }
            }
        }
        if (groupId == null || artifactId == null || NBlankable.isBlank(version)) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid descriptor id %s:%s#%s", groupId, artifactId, version));
        }
        return nutsDescriptor.builder().setId(NIdBuilder.of(groupId, artifactId).setVersion(version).build()).build();
    }

    public static void checkValidEffectiveDescriptor(NDescriptor effectiveDescriptor) {
        NAssert.requireNonNull(effectiveDescriptor, "effective descriptor");
        boolean topException = false;
        try {
            for (NId parent : effectiveDescriptor.getParents()) {
                CoreNIdUtils.checkValidEffectiveId(parent);
            }
            CoreNIdUtils.checkValidEffectiveId(effectiveDescriptor.getId());
            for (NDependency dependency : effectiveDescriptor.getDependencies()) {
                if (CoreNIdUtils.isValidEffectiveId(dependency.toId())) continue;
                NMsg errMsg = NMsg.ofC("%s is using dependency %s which defines an unresolved variable. This is a potential bug.", effectiveDescriptor.getId(), dependency);
                NLog.of(NDescriptorUtils.class).log(errMsg.withIntent(NMsgIntent.ALERT).withLevel(Level.FINE));
                if (dependency.isOptional()) continue;
                topException = true;
                throw new NArtifactNotFoundException(effectiveDescriptor.getId(), errMsg);
            }
            for (NDependency dependency : effectiveDescriptor.getStandardDependencies()) {
                if (CoreNIdUtils.isValidEffectiveId(dependency.toId())) continue;
                NLog.of(NDescriptorUtils.class).log(NMsg.ofC("%s is using standard-dependency %s which defines an unresolved variable. This is a potential bug.", effectiveDescriptor.getId(), dependency).withIntent(NMsgIntent.ALERT).withLevel(Level.FINE));
            }
        }
        catch (NIllegalArgumentException ex) {
            if (topException) {
                throw ex;
            }
            throw new NIllegalArgumentException(NMsg.ofC("unable to evaluate effective descriptor for %s", effectiveDescriptor.getId()), (Throwable)ex);
        }
        catch (NArtifactNotFoundException ex) {
            throw new NArtifactNotFoundException(effectiveDescriptor.getId(), NMsg.ofC("unable to evaluate effective descriptor for %s", effectiveDescriptor.getId()), ex);
        }
        catch (Exception ex) {
            throw new NIllegalArgumentException(NMsg.ofC("unable to evaluate effective descriptor for %s", effectiveDescriptor.getId()), (Throwable)ex);
        }
    }

    public static boolean isValidEffectiveDescriptor(NDescriptor effectiveDescriptor) {
        try {
            NDescriptorUtils.checkValidEffectiveDescriptor(effectiveDescriptor);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static NEnvConditionBuilder simplifyNutsEnvConditionBuilder(NEnvConditionBuilder c) {
        c.setArch(NCollections.toDistinctTrimmedNonEmptyList(c.getArch()));
        c.setOs(NCollections.toDistinctTrimmedNonEmptyList(c.getOs()));
        c.setOsDist(NCollections.toDistinctTrimmedNonEmptyList(c.getOsDist()));
        c.setPlatform(NCollections.toDistinctTrimmedNonEmptyList(c.getPlatform()));
        c.setDesktopEnvironment(NCollections.toDistinctTrimmedNonEmptyList(c.getDesktopEnvironment()));
        c.setProfile(NCollections.toDistinctTrimmedNonEmptyList(c.getProfiles()));
        return c;
    }

    public static NEnvConditionBuilder applyPropertiesNutsEnvCondition(NEnvConditionBuilder c, Map<String, String> properties) {
        MapToFunction<String, String> map = new MapToFunction<String, String>(properties);
        c.setArch(CoreNUtils.applyStringPropertiesList(c.getArch(), map));
        c.setOs(CoreNUtils.applyStringPropertiesList(c.getOs(), map));
        c.setOsDist(CoreNUtils.applyStringPropertiesList(c.getOsDist(), map));
        c.setPlatform(CoreNUtils.applyStringPropertiesList(c.getPlatform(), map));
        c.setDesktopEnvironment(CoreNUtils.applyStringPropertiesList(c.getDesktopEnvironment(), map));
        c.setProfile(CoreNUtils.applyStringPropertiesList(c.getProfiles(), map));
        return c;
    }

    public static NEnvConditionBuilder applyPropertiesNutsEnvCondition2(NEnvConditionBuilder c, Map<String, NDescriptorProperty> properties) {
        StringStringFunctionFromNDescriptorProperty map = new StringStringFunctionFromNDescriptorProperty(properties);
        c.setArch(CoreNUtils.applyStringPropertiesList(c.getArch(), map));
        c.setOs(CoreNUtils.applyStringPropertiesList(c.getOs(), map));
        c.setOsDist(CoreNUtils.applyStringPropertiesList(c.getOsDist(), map));
        c.setPlatform(CoreNUtils.applyStringPropertiesList(c.getPlatform(), map));
        c.setDesktopEnvironment(CoreNUtils.applyStringPropertiesList(c.getDesktopEnvironment(), map));
        c.setProfile(CoreNUtils.applyStringPropertiesList(c.getProfiles(), map));
        return c;
    }

    public static NEnvCondition applyNutsConditionProperties(NEnvCondition child, Function<String, String> properties) {
        return child.builder().setOs(CoreNUtils.applyStringProperties(child.getOs(), properties)).setOsDist(CoreNUtils.applyStringProperties(child.getOsDist(), properties)).setPlatform(CoreNUtils.applyStringProperties(child.getPlatform(), properties)).setProfile(CoreNUtils.applyStringProperties(child.getProfiles(), properties)).setDesktopEnvironment(CoreNUtils.applyStringProperties(child.getDesktopEnvironment(), properties)).setArch(CoreNUtils.applyStringProperties(child.getArch(), properties)).build();
    }

    public static NId applyNutsIdProperties(NDescriptor d, NId child, Function<String, String> properties) {
        return NIdBuilder.of().setRepository(CoreNUtils.applyStringProperties(child.getRepository(), properties)).setGroupId(CoreNUtils.applyStringProperties(child.getGroupId(), properties)).setArtifactId(CoreNUtils.applyStringProperties(child.getArtifactId(), properties)).setVersion(CoreNUtils.applyStringProperties(child.getVersion().getValue(), properties)).setCondition(NDescriptorUtils.applyNutsConditionProperties(child.getCondition(), properties)).setClassifier(CoreNUtils.applyStringProperties(child.getClassifier(), properties)).setPackaging(CoreNUtils.applyStringProperties(child.getPackaging(), properties)).setProperties(CoreNUtils.applyMapProperties(child.getProperties(), properties)).build();
    }

    public static NDependencyBuilder applyNutsDependencyProperties(NDescriptorBuilder d, NDependency child, Function<String, String> properties) {
        List<NId> exclusions = child.getExclusions().stream().map(x -> NDescriptorUtils.applyNutsIdProperties(d.build(), x, properties)).collect(Collectors.toList());
        return NDependencyBuilder.of().setRepository(CoreNUtils.applyStringProperties(child.getRepository(), properties)).setGroupId(CoreNUtils.applyStringProperties(child.getGroupId(), properties)).setArtifactId(CoreNUtils.applyStringProperties(child.getArtifactId(), properties)).setVersion(CoreNUtils.applyStringProperties(child.getVersion(), properties)).setClassifier(CoreNUtils.applyStringProperties(child.getClassifier(), properties)).setScope(CoreNUtils.applyStringProperties(child.getScope(), properties)).setOptional(CoreNUtils.applyStringProperties(child.getOptional(), properties)).setCondition(NDescriptorUtils.applyNutsConditionProperties(child.getCondition(), properties)).setType(CoreNUtils.applyStringProperties(child.getType(), properties)).setExclusions(exclusions).setPropertiesQuery(CoreNUtils.applyStringProperties(child.getPropertiesQuery(), properties));
    }

    public static NIdBuilder applyProperties(NIdBuilder b, Function<String, String> properties) {
        b.setGroupId(CoreNUtils.applyStringProperties(b.getGroupId(), properties));
        b.setArtifactId(CoreNUtils.applyStringProperties(b.getArtifactId(), properties));
        b.setVersion(CoreNUtils.applyStringProperties(b.getVersion().getValue(), properties));
        b.setClassifier(CoreNUtils.applyStringProperties(b.getClassifier(), properties));
        b.setProperties(CoreNUtils.applyMapProperties(b.getProperties(), properties));
        return b;
    }

    public static NDescriptorBuilder applyProperties(NDescriptorBuilder b) {
        Map<String, NDescriptorProperty> propertiesMap = NDescriptorUtils.getPropertiesMap2(b.getProperties());
        if (b.getId() != null) {
            NId id = b.getId();
            String gid = id.getGroupId();
            String version = id.getVersion().getValue();
            if (gid != null && !propertiesMap.containsKey("groupId")) {
                propertiesMap.put("groupId", DefaultNDescriptorProperty.of("groupId", gid));
            }
            if (version != null && !propertiesMap.containsKey("version")) {
                propertiesMap.put("version", DefaultNDescriptorProperty.of("version", version));
            }
        }
        return NDescriptorUtils.applyProperties2(b, propertiesMap);
    }

    private static String sPropId(NDescriptorProperty d) {
        return NStringUtils.trim(d.getName()) + ":" + d.getCondition().toString();
    }

    private static Map<String, NDescriptorProperty> propsAsMap(List<NDescriptorProperty> arr) {
        LinkedHashMap<String, NDescriptorProperty> m = new LinkedHashMap<String, NDescriptorProperty>();
        for (NDescriptorProperty p : arr) {
            String s = NDescriptorUtils.sPropId(p);
            m.put(s, p);
        }
        return m;
    }

    public static NDescriptorBuilder applyParents(NDescriptorBuilder b, List<NDescriptor> parentDescriptors) {
        NId n_id = b.getId();
        String n_packaging = b.getPackaging();
        LinkedHashSet<NDescriptorFlag> flags = new LinkedHashSet<NDescriptorFlag>(b.getFlags());
        String n_name = b.getName();
        List<String> n_categories = b.getCategories();
        n_categories = n_categories == null ? new ArrayList<String>() : new ArrayList<String>(n_categories);
        List<String> n_icons = b.getIcons();
        n_icons = n_icons == null ? new ArrayList<String>() : new ArrayList<String>(n_icons);
        String n_genericName = b.getGenericName();
        String n_desc = b.getDescription();
        NArtifactCall n_executor = b.getExecutor();
        NArtifactCall n_installer = b.getInstaller();
        LinkedHashMap<String, NDescriptorProperty> n_props = new LinkedHashMap<String, NDescriptorProperty>();
        for (NDescriptor parentDescriptor : parentDescriptors) {
            List<NDescriptorProperty> properties = parentDescriptor.getProperties();
            if (properties == null) continue;
            n_props.putAll(NDescriptorUtils.propsAsMap(properties));
        }
        List<NDescriptorProperty> properties = b.getProperties();
        if (properties != null) {
            n_props.putAll(NDescriptorUtils.propsAsMap(properties));
        }
        DefaultNEnvConditionBuilder b2 = new DefaultNEnvConditionBuilder();
        LinkedHashMap<String, NDependency> n_deps = new LinkedHashMap<String, NDependency>();
        LinkedHashMap<String, NDependency> n_sdeps = new LinkedHashMap<String, NDependency>();
        for (NDescriptor parentDescriptor : parentDescriptors) {
            n_id = CoreNUtils.applyNutsIdInheritance(n_id, parentDescriptor.getId());
            flags.addAll(parentDescriptor.getFlags());
            if (n_executor == null) {
                n_executor = parentDescriptor.getExecutor();
            }
            if (n_installer == null) {
                n_installer = parentDescriptor.getInstaller();
            }
            n_name = CoreNUtils.applyStringInheritance(n_name, parentDescriptor.getName());
            n_genericName = CoreNUtils.applyStringInheritance(n_genericName, parentDescriptor.getGenericName());
            n_desc = CoreNUtils.applyStringInheritance(n_desc, parentDescriptor.getDescription());
            n_deps.putAll(NDescriptorUtils.depsAsMap(parentDescriptor.getDependencies()));
            n_sdeps.putAll(NDescriptorUtils.depsAsMap(parentDescriptor.getStandardDependencies()));
            b2.copyFrom(parentDescriptor.getCondition());
            n_icons.addAll(parentDescriptor.getIcons());
            n_categories.addAll(parentDescriptor.getCategories());
        }
        n_deps.putAll(NDescriptorUtils.depsAsMap(b.getDependencies()));
        n_sdeps.putAll(NDescriptorUtils.depsAsMap(b.getStandardDependencies()));
        b2.copyFrom(b.getCondition());
        ArrayList<NId> n_parents = new ArrayList<NId>();
        b.setId(n_id);
        b.setParents(n_parents);
        b.setPackaging(n_packaging);
        b.setFlags(flags);
        b.setExecutor(n_executor);
        b.setInstaller(n_installer);
        b.setName(n_name);
        b.setGenericName(n_genericName);
        b.setCategories(new ArrayList<String>(new LinkedHashSet<String>(n_categories)));
        b.setIcons(new ArrayList<String>(new LinkedHashSet<String>(n_icons)));
        b.setDescription(n_desc);
        b.setCondition(b2);
        b.setDependencies(new ArrayList<NDependency>(n_deps.values()));
        b.setStandardDependencies(new ArrayList<NDependency>(n_sdeps.values()));
        b.setProperties(new ArrayList<NDescriptorProperty>(n_props.values()));
        return b;
    }

    public static NDescriptorBuilder applyProperties(NDescriptorBuilder b, Map<String, String> properties) {
        properties = NDescriptorUtils.applyPropsToProps(b, properties);
        MapToFunction<String, String> map = new MapToFunction<String, String>(properties);
        NId n_id = NDescriptorUtils.applyProperties(b.getId().builder(), map).build();
        String n_packaging = CoreNUtils.applyStringProperties(b.getPackaging(), map);
        String n_name = CoreNUtils.applyStringProperties(b.getName(), map);
        String n_desc = CoreNUtils.applyStringProperties(b.getDescription(), map);
        NArtifactCall n_executor = b.getExecutor();
        NArtifactCall n_installer = b.getInstaller();
        DefaultNProperties n_props = new DefaultNProperties();
        for (NDescriptorProperty nDescriptorProperty : b.getProperties()) {
            String v = nDescriptorProperty.getValue().asString().get();
            if (CoreStringUtils.containsVars("${")) {
                n_props.add(nDescriptorProperty.builder().setValue(CoreNUtils.applyStringProperties(v, map)).build());
                continue;
            }
            n_props.add(nDescriptorProperty);
        }
        LinkedHashSet<NDependency> n_deps = new LinkedHashSet<NDependency>();
        for (NDependency d2 : b.getDependencies()) {
            n_deps.add(NDescriptorUtils.applyNutsDependencyProperties(b, d2, map).build());
        }
        LinkedHashSet<NDependency> linkedHashSet = new LinkedHashSet<NDependency>();
        for (NDependency d2 : b.getStandardDependencies()) {
            linkedHashSet.add(NDescriptorUtils.applyNutsDependencyProperties(b, d2, map).build());
        }
        b.setId(n_id);
        b.setParents(b.getParents());
        b.setPackaging(n_packaging);
        b.setExecutor(n_executor);
        b.setInstaller(n_installer);
        b.setName(n_name);
        b.setDescription(n_desc);
        b.setGenericName(CoreNUtils.applyStringProperties(b.getGenericName(), map));
        b.setIcons(b.getIcons().stream().map(x -> CoreNUtils.applyStringProperties(x, (Function<String, String>)map)).collect(Collectors.toList()));
        b.setCategories(b.getCategories().stream().map(x -> CoreNUtils.applyStringProperties(x, (Function<String, String>)map)).collect(Collectors.toList()));
        b.setCondition(NDescriptorUtils.applyPropertiesNutsEnvCondition(b.getCondition(), properties).build());
        b.setDependencies(new ArrayList<NDependency>(n_deps));
        b.setStandardDependencies(new ArrayList<NDependency>(linkedHashSet));
        b.setProperties(n_props.toList());
        return b;
    }

    public static NDescriptorBuilder applyProperties2(NDescriptorBuilder b, Map<String, NDescriptorProperty> properties) {
        Map<String, NDescriptorProperty> finalProperties = properties = NDescriptorUtils.applyPropsToProps2(b, properties);
        StringStringFunctionFromNDescriptorProperty map = new StringStringFunctionFromNDescriptorProperty(finalProperties);
        NId n_id = NDescriptorUtils.applyProperties(b.getId().builder(), map).build();
        String n_packaging = CoreNUtils.applyStringProperties(b.getPackaging(), (Function<String, String>)map);
        String n_name = CoreNUtils.applyStringProperties(b.getName(), (Function<String, String>)map);
        String n_desc = CoreNUtils.applyStringProperties(b.getDescription(), (Function<String, String>)map);
        NArtifactCall n_executor = b.getExecutor();
        NArtifactCall n_installer = b.getInstaller();
        DefaultNProperties n_props = new DefaultNProperties();
        for (NDescriptorProperty nDescriptorProperty : b.getProperties()) {
            String v = nDescriptorProperty.getValue().asString().get();
            if (CoreStringUtils.containsVars("${")) {
                n_props.add(nDescriptorProperty.builder().setValue(CoreNUtils.applyStringProperties(v, (Function<String, String>)map)).build());
                continue;
            }
            n_props.add(nDescriptorProperty);
        }
        LinkedHashSet<NDependency> n_deps = new LinkedHashSet<NDependency>();
        for (NDependency d2 : b.getDependencies()) {
            n_deps.add(NDescriptorUtils.applyNutsDependencyProperties(b, d2, map).build());
        }
        LinkedHashSet<NDependency> linkedHashSet = new LinkedHashSet<NDependency>();
        for (NDependency d2 : b.getStandardDependencies()) {
            linkedHashSet.add(NDescriptorUtils.applyNutsDependencyProperties(b, d2, map).build());
        }
        b.setId(n_id);
        b.setParents(b.getParents());
        b.setPackaging(n_packaging);
        b.setExecutor(n_executor);
        b.setInstaller(n_installer);
        b.setName(n_name);
        b.setDescription(n_desc);
        b.setGenericName(CoreNUtils.applyStringProperties(b.getGenericName(), (Function<String, String>)map));
        b.setIcons(b.getIcons().stream().map(x -> CoreNUtils.applyStringProperties(x, (Function<String, String>)map)).collect(Collectors.toList()));
        b.setCategories(b.getCategories().stream().map(x -> CoreNUtils.applyStringProperties(x, (Function<String, String>)map)).collect(Collectors.toList()));
        b.setCondition(NDescriptorUtils.applyPropertiesNutsEnvCondition2(b.getCondition(), properties).build());
        b.setDependencies(new ArrayList<NDependency>(n_deps));
        b.setStandardDependencies(new ArrayList<NDependency>(linkedHashSet));
        b.setProperties(n_props.toList());
        return b;
    }

    private static Map<String, String> prepareGlobalProperties(NDescriptorBuilder b) {
        LinkedHashMap<String, String> global = new LinkedHashMap<String, String>();
        global.putAll(System.getProperties());
        NId ii = b.getId();
        for (String s : new String[]{"project.name", "pom.name"}) {
            global.put(s, b.getName());
        }
        if (ii != null) {
            if (ii.getVersion().getValue() != null) {
                for (String s : new String[]{"project.version", "version", "pom.version"}) {
                    global.put(s, ii.getVersion().getValue());
                }
            }
            for (String s : new String[]{"project.groupId", "pom.groupId"}) {
                global.put(s, ii.getGroupId());
            }
            for (String s : new String[]{"project.artifactId", "pom.artifactId"}) {
                global.put(s, ii.getArtifactId());
            }
        }
        return global;
    }

    private static Map<String, NDescriptorProperty> prepareGlobalProperties2(NDescriptorBuilder b) {
        LinkedHashMap<String, NDescriptorProperty> global = new LinkedHashMap<String, NDescriptorProperty>();
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String k = (String)e.getKey();
            global.put(k, DefaultNDescriptorProperty.of(k, e.getValue()));
        }
        NId ii = b.getId();
        for (String s : new String[]{"project.name", "pom.name"}) {
            global.put(s, DefaultNDescriptorProperty.of(s, b.getName()));
        }
        if (ii != null) {
            if (ii.getVersion().getValue() != null) {
                for (String s : new String[]{"project.version", "version", "pom.version"}) {
                    global.put(s, DefaultNDescriptorProperty.of(s, ii.getVersion().getValue()));
                }
            }
            for (String s : new String[]{"project.groupId", "pom.groupId"}) {
                global.put(s, DefaultNDescriptorProperty.of(s, ii.getGroupId()));
            }
            for (String s : new String[]{"project.artifactId", "pom.artifactId"}) {
                global.put(s, DefaultNDescriptorProperty.of(s, ii.getArtifactId()));
            }
        }
        return global;
    }

    private static Map<String, String> applyPropsToProps(NDescriptorBuilder b, Map<String, String> properties) {
        LinkedHashMap<String, String> oldMap = new LinkedHashMap<String, String>(properties);
        for (Map.Entry<String, String> entry : NDescriptorUtils.prepareGlobalProperties(b).entrySet()) {
            if (oldMap.containsKey(entry.getKey())) continue;
            oldMap.put(entry.getKey(), entry.getValue());
        }
        TreeSet<String> updated = new TreeSet<String>();
        for (int i = 0; i < 16; ++i) {
            MapToFunction<String, String> fct = new MapToFunction<String, String>(oldMap);
            LinkedHashMap<String, String> newMap = new LinkedHashMap<String, String>(oldMap.size());
            updated = new TreeSet();
            for (Map.Entry entry : oldMap.entrySet()) {
                String v1;
                String v0 = (String)entry.getValue();
                if (!Objects.equals(v0, v1 = CoreNUtils.applyStringProperties(v0, fct))) {
                    updated.add((String)entry.getKey());
                }
                newMap.put((String)entry.getKey(), v1);
            }
            if (updated.isEmpty()) {
                return newMap;
            }
            oldMap = newMap;
        }
        throw new NIllegalArgumentException(NMsg.ofC("too many recursion applying properties %s", updated));
    }

    private static Map<String, NDescriptorProperty> applyPropsToProps2(NDescriptorBuilder b, Map<String, NDescriptorProperty> properties) {
        LinkedHashMap<String, NDescriptorProperty> oldMap = new LinkedHashMap<String, NDescriptorProperty>(properties);
        for (Map.Entry<String, NDescriptorProperty> entry : NDescriptorUtils.prepareGlobalProperties2(b).entrySet()) {
            if (oldMap.containsKey(entry.getKey())) continue;
            oldMap.put(entry.getKey(), entry.getValue());
        }
        TreeSet<String> updated = new TreeSet<String>();
        for (int i = 0; i < 16; ++i) {
            StringStringFunctionFromNDescriptorProperty fct = new StringStringFunctionFromNDescriptorProperty(oldMap);
            LinkedHashMap<String, NDescriptorProperty> newMap = new LinkedHashMap<String, NDescriptorProperty>(oldMap.size());
            updated = new TreeSet();
            for (Map.Entry entry : oldMap.entrySet()) {
                NDescriptorProperty v00 = (NDescriptorProperty)entry.getValue();
                if (NBlankable.isBlank(v00.getCondition())) {
                    String v1;
                    String v0 = v00.getValue().asString().orNull();
                    if (!Objects.equals(v0, v1 = CoreNUtils.applyStringProperties(v0, (Function<String, String>)fct))) {
                        updated.add((String)entry.getKey());
                    }
                    newMap.put((String)entry.getKey(), DefaultNDescriptorProperty.of((String)entry.getKey(), v1));
                    continue;
                }
                newMap.put((String)entry.getKey(), (NDescriptorProperty)entry.getValue());
            }
            if (updated.isEmpty()) {
                return newMap;
            }
            oldMap = newMap;
        }
        throw new NIllegalArgumentException(NMsg.ofC("too many recursion applying properties %s", updated));
    }

    private static Map<String, NDependency> depsAsMap(List<NDependency> arr) {
        LinkedHashMap<String, NDependency> m = new LinkedHashMap<String, NDependency>();
        for (NDependency d : arr) {
            String e = NDescriptorUtils.sDepId(d);
            if (!m.containsKey(e)) {
                m.put(e, d);
                continue;
            }
            NDependency a = (NDependency)m.get(e);
            if (a.equals(d)) {
                NLog.of(DefaultNDescriptorBuilder.class).log(NMsg.ofC("dependency %s is duplicated", d).withLevel(Level.FINER).withIntent(NMsgIntent.ALERT));
                continue;
            }
            NLog.of(DefaultNDescriptorBuilder.class).log(NMsg.ofC("dependency %s is overridden by %s", a, d).withLevel(Level.FINER).withIntent(NMsgIntent.ALERT));
        }
        return m;
    }

    private static String sDepId(NDependency d) {
        return NStringUtils.trim(d.getGroupId()) + ":" + NStringUtils.trim(d.getArtifactId()) + "?" + NStringUtils.trim(d.getClassifier());
    }

    private static class StringStringFunctionFromNDescriptorProperty
    implements Function<String, String> {
        private final Map<String, NDescriptorProperty> finalProperties;

        public StringStringFunctionFromNDescriptorProperty(Map<String, NDescriptorProperty> finalProperties) {
            this.finalProperties = finalProperties;
        }

        @Override
        public String apply(String s) {
            NEnvCondition cc;
            NDescriptorProperty p = this.finalProperties.get(s);
            if (p != null && this.isAcceptProfiles((cc = p.getCondition()).getProfiles())) {
                if (NBlankable.isBlank(cc)) {
                    return p.getValue().asString().orNull();
                }
                throw new IllegalArgumentException("unsupported condition " + cc + " for " + p);
            }
            switch (s) {
                case "os.detected.name": {
                    return NWorkspace.of().getOs().getArtifactId();
                }
                case "os.detected.version": {
                    return NWorkspace.of().getOs().getVersion().toString();
                }
                case "os.detected.os.release": {
                    return NWorkspace.of().getOsDist().getArtifactId();
                }
                case "os.detected.release.version": {
                    return NWorkspace.of().getOsDist().getVersion().toString();
                }
                case "os.detected.arch": {
                    return NWorkspace.of().getArch().getArtifactId();
                }
                case "os.detected.classifier": {
                    return NWorkspace.of().getOs().getArtifactId() + "-" + NWorkspace.of().getArch().getArtifactId();
                }
                case "os.detected.bitness": {
                    return String.valueOf(NWorkspace.of().getArchFamily().getBits());
                }
                case "os.detected.release.like": {
                    return NWorkspace.of().getOsDist().getProperties().get("like");
                }
                case "os.detected.release.codename": {
                    return NWorkspace.of().getOsDist().getProperties().get("codename");
                }
            }
            return null;
        }

        private boolean isAcceptProfiles(List<String> profiles) {
            return profiles.isEmpty();
        }
    }
}

