/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.artifact.NArtifactCallBuilder;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.format.json.JsonStringBuffer;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NDescriptorContentParserContext;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.WORKSPACE)
public class NshDescriptorContentParserComponent
implements NDescriptorContentParserComponent {
    public static NId NSH;
    public static final Set<String> POSSIBLE_EXT;

    public NshDescriptorContentParserComponent() {
        if (NSH == null) {
            NSH = NId.get("nsh").get();
        }
    }

    @Override
    public NDescriptor parse(NDescriptorContentParserContext parserContext) {
        if (!POSSIBLE_EXT.contains(parserContext.getFileExtension())) {
            return null;
        }
        try {
            return NshDescriptorContentParserComponent.readNutDescriptorFromBashScriptFile(parserContext.getFullStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public int getScore(NScorableContext criteria) {
        NDescriptorContentParserContext ctr = criteria.getCriteria(NDescriptorContentParserContext.class);
        if (ctr != null) {
            String e;
            switch (e = NStringUtils.trim(ctr.getFileExtension())) {
                case "": 
                case "sh": 
                case "nsh": 
                case "bash": {
                    return 10;
                }
            }
        }
        return -1;
    }

    private static String removeBashComment(String str) {
        int x = 0;
        for (int i = 0; i < str.length() && (str.charAt(i) == '#' || str.charAt(i) == ' '); ++i) {
            x = i + 1;
        }
        if (x < str.length()) {
            return str.substring(x);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NDescriptor readNutDescriptorFromBashScriptFile(InputStream file) throws IOException {
        try (BufferedReader r = null;){
            Object object;
            r = new BufferedReader(new InputStreamReader(file));
            String line = null;
            boolean firstLine = true;
            JsonStringBuffer comment = new JsonStringBuffer();
            String sheban = "";
            boolean start = false;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                if (!line.startsWith("#")) break;
                line = NshDescriptorContentParserComponent.removeBashComment(line);
                if (firstLine) {
                    firstLine = false;
                    if (!line.startsWith("!")) break;
                    sheban = line.substring(1).trim();
                }
                if (!start && line.matches("@nuts((\\s|\\{).*)?")) {
                    start = true;
                    String substring = line.substring(line.indexOf("@nuts") + "@nuts".length());
                    if (!comment.append(substring)) continue;
                    break;
                }
                if (!start || !comment.append(line)) continue;
            }
            switch (sheban) {
                case "/bin/sh": 
                case "/bin/nsh": 
                case "/bin/nuts": 
                case "/bin/bash": {
                    break;
                }
                default: {
                    NDescriptor nDescriptor = null;
                    return nDescriptor;
                }
            }
            if (comment.toString().trim().isEmpty()) {
                object = new DefaultNDescriptorBuilder().setId(NId.get("temp:nsh#1.0").get()).setPackaging("nsh").setExecutor(NArtifactCallBuilder.of().setId(NId.of("net.thevpc.nsh:nsh")).build()).build();
                return object;
            }
            object = NDescriptorParser.of().parse(comment.getValidString()).get();
            return object;
        }
    }

    static {
        POSSIBLE_EXT = new HashSet<String>(Arrays.asList("nsh", "sh", "bash"));
    }
}

