/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NDescriptorParser;
import net.thevpc.nuts.artifact.NDescriptorStyle;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NFetchMode;
import net.thevpc.nuts.runtime.standalone.DefaultNArtifactCallBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorBuilder;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenUtils;
import net.thevpc.nuts.runtime.standalone.security.util.CoreDigestHelper;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NDescriptorContentParserContext;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NVisitResult;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NRef;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.WORKSPACE)
public class JarDescriptorContentParserComponent
implements NDescriptorContentParserComponent {
    public static final Set<String> POSSIBLE_EXT = new HashSet<String>(Collections.singletonList("jar"));

    @Override
    public int getScore(NScorableContext criteria) {
        NDescriptorContentParserContext cons = criteria.getCriteria(NDescriptorContentParserContext.class);
        if (cons != null) {
            String e;
            switch (e = NStringUtils.trim(cons.getFileExtension())) {
                case "jar": 
                case "war": 
                case "ear": {
                    return 20;
                }
                case "zip": {
                    return 15;
                }
            }
        }
        return -1;
    }

    @Override
    public NDescriptor parse(NDescriptorContentParserContext parserContext) {
        if (!POSSIBLE_EXT.contains(parserContext.getFileExtension())) {
            return null;
        }
        NId JAVA = NId.get("java").get();
        NRef nutsjson = NRef.ofNull();
        NRef metainf = NRef.ofNull();
        NRef maven = NRef.ofNull();
        ZipUtils.visitZipStream(parserContext.getFullStream(), (path, inputStream) -> {
            switch (path) {
                case "META-INF/MANIFEST.MF": {
                    try {
                        metainf.setNonNull(NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.MANIFEST).parse(inputStream).orNull());
                        break;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                case "META-INF/nuts.json": {
                    try {
                        nutsjson.setNonNull(NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.NUTS).parse(inputStream).get());
                        break;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                default: {
                    if (path.startsWith("META-INF/maven/") && path.endsWith("/pom.xml")) {
                        try {
                            maven.setNonNull(MavenUtils.of().parsePomXmlAndResolveParents(inputStream, NFetchMode.REMOTE, path, null));
                            break;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    if (!path.startsWith("META-INF/nuts/") || !path.endsWith("/nuts.json")) break;
                    try {
                        nutsjson.setNonNull(NDescriptorParser.of().setDescriptorStyle(NDescriptorStyle.NUTS).parse(inputStream).get());
                        break;
                    }
                    finally {
                        inputStream.close();
                    }
                }
            }
            if (!nutsjson.isSet() || !metainf.isSet() && !maven.isSet()) {
                return NVisitResult.CONTINUE;
            }
            return NVisitResult.TERMINATE;
        });
        if (nutsjson.isSet()) {
            return (NDescriptor)nutsjson.get();
        }
        String mainClassString = null;
        if (metainf.isSet() && ((NDescriptor)metainf.get()).getExecutor() != null) {
            List<String> args = ((NDescriptor)metainf.get()).getExecutor().getArguments();
            for (int i = 0; i < args.size(); ++i) {
                String arg = args.get(i);
                if (arg.startsWith("--main-class=")) {
                    mainClassString = NStringUtils.trimToNull(arg.substring("--main-class=".length()));
                    break;
                }
                if (!arg.equals("--main-class") || ++i >= args.size()) continue;
                mainClassString = NStringUtils.trimToNull(args.get(i));
            }
        }
        NDescriptor baseNutsDescriptor = null;
        if (maven.isSet()) {
            baseNutsDescriptor = (NDescriptor)maven.get();
            if (!NBlankable.isBlank(mainClassString)) {
                return baseNutsDescriptor.builder().setExecutor(new DefaultNArtifactCallBuilder().setId(JAVA).setArguments("--main-class=", mainClassString).build()).build();
            }
        } else if (metainf.isSet()) {
            baseNutsDescriptor = (NDescriptor)metainf.get();
        }
        if (baseNutsDescriptor == null) {
            CoreDigestHelper d = new CoreDigestHelper();
            d.append(parserContext.getFullStream());
            String artifactId = d.getDigest();
            baseNutsDescriptor = new DefaultNDescriptorBuilder().setId(NIdBuilder.of("temp", artifactId).setVersion("1.0").build()).addFlag(mainClassString != null ? NDescriptorFlag.EXEC : null).setPackaging("jar").build();
        }
        boolean alwaysSelectAllMainClasses = false;
        NCmdLine cmd = NCmdLine.of(parserContext.getParseOptions());
        while (!cmd.isEmpty()) {
            NArg a = cmd.nextFlag("--all-mains").orNull();
            if (a != null) {
                alwaysSelectAllMainClasses = a.getBooleanValue().get();
                continue;
            }
            cmd.skip();
        }
        return baseNutsDescriptor;
    }
}

