/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.spi.NDescriptorContentParserContext;
import net.thevpc.nuts.text.NMsg;

public class DefaultNDescriptorContentParserContext
implements NDescriptorContentParserContext {
    private final NPath file;
    private final String fileExtension;
    private final String mimeType;
    private byte[] bytes;
    private final List<String> parseOptions;

    public DefaultNDescriptorContentParserContext(Path file, String fileExtension, String mimeType, List<String> parseOptions) {
        this.file = NPath.of(file);
        this.fileExtension = fileExtension;
        this.mimeType = mimeType;
        this.parseOptions = parseOptions;
    }

    @Override
    public List<String> getParseOptions() {
        return this.parseOptions;
    }

    @Override
    public InputStream getHeadStream() {
        if (this.bytes == null) {
            try (InputStream is = this.file.getInputStream();){
                this.bytes = NIOUtils.loadByteArray(is, 0xA00000, true);
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
        }
        return CoreIOUtils.createBytesStream(this.bytes, NMsg.ofC("%s", this.file), this.file.getContentType(), this.file.getCharset(), this.file.getMetaData().getKind().orNull());
    }

    @Override
    public InputStream getFullStream() {
        return this.file.getInputStream();
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }
}

