/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.solver.maven;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyBuilder;
import net.thevpc.nuts.artifact.NDependencyTreeNode;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorEffectiveConfig;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.runtime.standalone.dependency.DefaultNDependencyTreeNode;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.MavenNDependencySolver;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.NDependencyInfo;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;

class NDependencyTreeNodeBuild {
    private final MavenNDependencySolver mavenNDependencySolver;
    NDependencyTreeNodeBuild parent;
    NId id;
    NDefinition def;
    NDependency dependency;
    NDependency effDependency;
    List<NDependencyTreeNodeBuild> children = new ArrayList<NDependencyTreeNodeBuild>();
    List<NId> exclusions = new ArrayList<NId>();
    boolean alreadyVisited;
    boolean provided;
    boolean optional;
    int depth;
    NDescriptor effDescriptor;
    NDependencyInfo key;
    boolean built;
    boolean includedInClassPath;

    public NDependencyTreeNodeBuild(MavenNDependencySolver mavenNDependencySolver, NDependencyTreeNodeBuild parent, NDependency dependency, NDefinition def, int depth) {
        this.mavenNDependencySolver = mavenNDependencySolver;
        this.dependency = dependency;
        this.parent = parent;
        this.depth = depth;
        this.def = def;
        this.id = def != null ? def.getId() : dependency.toId();
        this.provided = dependency.isProvided() || parent != null && parent.provided;
        this.optional = dependency.isOptional() || parent != null && parent.optional;
    }

    public void build0() {
        if (this.built) {
            return;
        }
        try {
            if (this.def == null) {
                this.def = this.mavenNDependencySolver.searchOne(this.dependency);
            }
            if (this.def == null) {
                this.key = NDependencyInfo.of(this);
                this.effDependency = this.dependency;
                if (this.parent != null) {
                    this.exclusions.addAll(this.parent.exclusions);
                }
                this.addExclusions(this.dependency);
                if (this.optional) {
                    return;
                }
                throw new NIllegalArgumentException(NMsg.ofC(NI18n.of("missing non optional dependency %s"), this.dependency));
            }
            this.id = this.def.getId();
            this.effDependency = this.dependency;
            this.effDependency = this.parent == null ? this.dependency.builder().setVersion(this.def.getId().getVersion()).build() : this.dependency.builder().setScope(this.mavenNDependencySolver.combineScopes(this.parent.effDependency.getScope(), this.dependency.getScope())).setVersion(this.def.getId().getVersion()).setProperty("provided-by", this.parent.id.toString()).build();
            this.key = NDependencyInfo.of(this);
            if (this.parent != null) {
                this.exclusions.addAll(this.parent.exclusions);
            }
            this.addExclusions(this.dependency);
        }
        finally {
            this.built = true;
        }
    }

    public boolean isAcceptableDependency(NDependency dependency) {
        if (this.exclusions.contains(NDependencyInfo.normalizedId(dependency))) {
            return false;
        }
        if (this.depth == 0) {
            return this.mavenNDependencySolver.effDependencyFilter.acceptDependency(dependency, this.getEffectiveId());
        }
        if (dependency.isAnyTest()) {
            return false;
        }
        return this.mavenNDependencySolver.effDependencyFilter.acceptDependency(dependency, this.getEffectiveId());
    }

    public String toString() {
        NDependencyBuilder d = this.dependency.builder();
        d.getCondition().setArch(new ArrayList<String>());
        d.getCondition().setOs(new ArrayList<String>());
        d.getCondition().setOsDist(new ArrayList<String>());
        d.getCondition().setDesktopEnvironment(new ArrayList<String>());
        d.getCondition().setPlatform(new ArrayList<String>());
        return "NDependencyTreeNodeBuild{dependency=" + d.build() + (this.provided ? ", provided=" + this.provided : "") + (this.optional ? ", optional=" + this.optional : "") + ", depth=" + this.depth + '}';
    }

    NId getEffectiveId() {
        return this.getEffectiveDescriptor().getId();
    }

    NDescriptor getEffectiveDescriptor() {
        if (this.effDescriptor == null && this.def != null) {
            this.effDescriptor = this.def.getEffectiveDescriptor().orNull();
            if (this.effDescriptor == null) {
                this.effDescriptor = NWorkspace.of().resolveEffectiveDescriptor(this.def.getDescriptor(), new NDescriptorEffectiveConfig().setIgnoreCurrentEnvironment(this.mavenNDependencySolver.isIgnoreCurrentEnvironment()));
                if (this.effDescriptor == null) {
                    throw new NIllegalArgumentException(NMsg.ofC(NI18n.of("expected an effective definition for %s"), this.def.getId()));
                }
            }
        }
        return this.effDescriptor;
    }

    NDependencyTreeNode build() {
        ArrayList<NDependencyTreeNode> nchildren = new ArrayList<NDependencyTreeNode>();
        for (int i = 0; i < this.children.size(); ++i) {
            NDependencyTreeNodeBuild e = this.children.get(i);
            if (!e.includedInClassPath) continue;
            nchildren.add(e.build());
        }
        return new DefaultNDependencyTreeNode(this.effDependency, nchildren, this.alreadyVisited, this.optional, this.provided);
    }

    public void addExclusions(NDependency dependency) {
        for (NId exclusion : dependency.getExclusions()) {
            this.exclusions.add(NDependencyInfo.normalizedId(exclusion));
        }
    }
}

