/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.solver.maven;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.NDependencyTreeNodeBuild;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.PassProcessor;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.RootInfo;
import net.thevpc.nuts.spi.NDependencySolver;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NNoSuchElementException;

public class MavenNDependencySolver
implements NDependencySolver {
    public boolean includedProvided = false;
    List<NDependencyTreeNodeBuild> defs = new ArrayList<NDependencyTreeNodeBuild>();
    private List<RootInfo> pending = new ArrayList<RootInfo>();
    private NDependencyFilter dependencyFilter;
    private NRepositoryFilter repositoryFilter;
    NDependencyFilter effDependencyFilter;
    private boolean failFast;
    boolean ignoreCurrentEnvironment;

    @Override
    public boolean isIgnoreCurrentEnvironment() {
        return this.ignoreCurrentEnvironment;
    }

    @Override
    public NDependencySolver setIgnoreCurrentEnvironment(boolean ignoreCurrentEnvironment) {
        this.ignoreCurrentEnvironment = ignoreCurrentEnvironment;
        return this;
    }

    public NDependencySolver addRootId(NId id) {
        this.pending.add(new RootInfo(id.toDependency(), null));
        return this;
    }

    @Override
    public NDependencySolver add(NDefinition def) {
        this.pending.add(new RootInfo(null, def));
        return this;
    }

    @Override
    public NDependencySolver add(NDependency dependency) {
        this.pending.add(new RootInfo(dependency, null));
        return this;
    }

    @Override
    public NDependencySolver setDependencyFilter(NDependencyFilter dependencyFilter) {
        this.dependencyFilter = dependencyFilter;
        this.effDependencyFilter = null;
        return this;
    }

    @Override
    public NDependencySolver setRepositoryFilter(NRepositoryFilter repositoryFilter) {
        this.repositoryFilter = repositoryFilter;
        return this;
    }

    @Override
    public NDependencies solve() {
        this.doLog("---- START SOLVE");
        if (this.getDependencyFilter() == null) {
            NDependencyFilters filter = NDependencyFilters.of();
            this.effDependencyFilter = (NDependencyFilter)filter.always();
        } else {
            this.effDependencyFilter = this.getDependencyFilter();
        }
        for (RootInfo rootInfo : this.pending) {
            this.addRootDefinition0(rootInfo.dependency, rootInfo.def);
        }
        this.pending.clear();
        PassProcessor pp = new PassProcessor(this);
        NDependencies run = pp.run();
        this.doLogDependencyTree(run);
        this.doLog("---- END SOLVE");
        return run;
    }

    private void doLogDependencyTree(NDependencies run) {
    }

    void doLog(String message) {
    }

    void logRejectedDependency(NDependency effDependency) {
    }

    @Override
    public NDependencySolver add(NDependency dependency, NDefinition def) {
        this.pending.add(new RootInfo(dependency, def));
        return this;
    }

    public NDependencySolver addRootDefinition0(NDependency dependency, NDefinition def) {
        if (dependency == null) {
            if (def != null) {
                dependency = def.getId().toDependency();
            } else {
                NAssert.requireNonNull(dependency, "dependency");
            }
        }
        NDependencyTreeNodeBuild info = new NDependencyTreeNodeBuild(this, null, dependency, def, 0);
        this.defs.add(info);
        return this;
    }

    NDefinition searchOne(NDependency dep) {
        NDefinition def = null;
        try {
            def = this.search(dep).getResultDefinitions().findFirst().orNull();
        }
        catch (NoSuchElementException | NArtifactNotFoundException | NNoSuchElementException ex) {
            this.doLog("Unable to load dependency: " + dep);
        }
        return def;
    }

    private NSearchCmd search(NDependency dep) {
        return NSearchCmd.of().addIds(dep.toId()).setDependencyFilter(this.getDependencyFilter()).setRepositoryFilter(this.getRepositoryFilter()).setIgnoreCurrentEnvironment(this.isIgnoreCurrentEnvironment()).setLatest(true);
    }

    public NRepositoryFilter getRepositoryFilter() {
        return this.repositoryFilter;
    }

    public NDependencyFilter getDependencyFilter() {
        return this.dependencyFilter;
    }

    NDependencyScope combineScopes(String parentScope0, String childScope0) {
        NDependencyScope parentScope = NDependencyScope.parse(parentScope0).orElse(NDependencyScope.API);
        NDependencyScope childScope = NDependencyScope.parse(childScope0).orElse(NDependencyScope.API);
        return this.combineScopes(parentScope, childScope);
    }

    private NDependencyScope combineScopes(NDependencyScope parentScope, NDependencyScope childScope) {
        boolean api;
        boolean other = parentScope.isOther() || childScope.isOther();
        boolean test = parentScope.isTest() || childScope.isTest();
        boolean system = !other && (parentScope.isSystem() || childScope.isSystem());
        boolean provided = !other && (parentScope.isProvided() || childScope.isProvided());
        boolean runtime = !other && (parentScope.isRuntime() || childScope.isRuntime());
        boolean impl = !other && !provided && !runtime && !system && (parentScope.isImplementation() || childScope.isImplementation());
        boolean bl = api = !other && !provided && !runtime && !system && !impl;
        if (test) {
            if (other) {
                return NDependencyScope.TEST_OTHER;
            }
            if (system) {
                return NDependencyScope.TEST_SYSTEM;
            }
            if (provided) {
                return NDependencyScope.TEST_PROVIDED;
            }
            if (runtime) {
                return NDependencyScope.TEST_RUNTIME;
            }
            if (impl) {
                return NDependencyScope.TEST_IMPLEMENTATION;
            }
            return NDependencyScope.TEST_API;
        }
        if (other) {
            return NDependencyScope.OTHER;
        }
        if (system) {
            return NDependencyScope.SYSTEM;
        }
        if (provided) {
            return NDependencyScope.PROVIDED;
        }
        if (runtime) {
            return NDependencyScope.RUNTIME;
        }
        if (impl) {
            return NDependencyScope.IMPLEMENTATION;
        }
        return NDependencyScope.API;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public MavenNDependencySolver setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    @Override
    public String getName() {
        return "maven";
    }
}

