/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.format;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdFormat;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NDependencyFormat;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNDependencyFormat
extends DefaultFormatBase<NDependencyFormat>
implements NDependencyFormat {
    private boolean omitRepository;
    private boolean omitGroup;
    private boolean omitImportedGroup;
    private boolean omitQuery = false;
    private boolean highlightImportedGroup;
    private NDependency value;
    private Set<String> queryPropertiesOmitted = new HashSet<String>();

    public DefaultNDependencyFormat(NWorkspace workspace) {
        super("dependency-format");
    }

    @Override
    public NDependencyFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    @Override
    public boolean isOmitRepository() {
        return this.omitRepository;
    }

    @Override
    public NDependencyFormat setOmitRepository(boolean omitRepository) {
        this.omitRepository = omitRepository;
        return this;
    }

    @Override
    public boolean isOmitGroupId() {
        return this.omitGroup;
    }

    @Override
    public NDependencyFormat setOmitGroupId(boolean omitGroup) {
        this.omitGroup = omitGroup;
        return this;
    }

    @Override
    public boolean isOmitImportedGroupId() {
        return this.omitImportedGroup;
    }

    @Override
    public NDependencyFormat setOmitImportedGroup(boolean omitImportedGroup) {
        this.omitImportedGroup = omitImportedGroup;
        return this;
    }

    @Override
    public boolean isOmitOtherProperties() {
        return this.omitQuery;
    }

    @Override
    public NDependencyFormat setOmitOtherProperties(boolean value) {
        this.omitQuery = value;
        return this;
    }

    @Override
    public boolean isHighlightImportedGroup() {
        return this.highlightImportedGroup;
    }

    @Override
    public NDependencyFormat setHighlightImportedGroup(boolean highlightImportedGroup) {
        this.highlightImportedGroup = highlightImportedGroup;
        return this;
    }

    @Override
    public NText format() {
        NIdBuilder id = this.value.toId().builder();
        Map<String, String> q = id.getProperties();
        block9: for (Map.Entry<String, String> e : q.entrySet()) {
            switch (e.getKey()) {
                case "scope": 
                case "optional": 
                case "exclusions": 
                case "type": {
                    continue block9;
                }
            }
            if (!this.isOmitOtherProperties()) continue;
            id.setProperty(e.getKey(), null);
        }
        NIdFormat id1 = NIdFormat.of();
        for (String omitQueryProperty : this.getOmitQueryProperties()) {
            id1.setOmitProperty(omitQueryProperty, true);
        }
        return id1.setValue(id.build()).setHighlightImportedGroupId(this.isHighlightImportedGroup()).setOmitOtherProperties(false).setOmitGroupId(this.isOmitGroupId()).setOmitImportedGroupId(this.isOmitImportedGroupId()).setOmitRepository(this.isOmitRepository()).setNtf(this.isNtf()).format();
    }

    @Override
    public NDependency getValue() {
        return this.value;
    }

    @Override
    public NDependencyFormat setValue(NDependency id) {
        this.value = id;
        return this;
    }

    @Override
    public boolean isOmitOptional() {
        return this.isOmitQueryProperty("optional");
    }

    @Override
    public NDependencyFormat setOmitOptional(boolean value) {
        return this.setOmitQueryProperty("optional", value);
    }

    @Override
    public boolean isOmitExclusions() {
        return this.isOmitQueryProperty("exclusions");
    }

    @Override
    public NDependencyFormat setOmitExclusions(boolean value) {
        return this.setOmitQueryProperty("exclusions", value);
    }

    @Override
    public boolean isOmitScope() {
        return this.isOmitQueryProperty("scope");
    }

    @Override
    public NDependencyFormat setOmitScope(boolean value) {
        return this.setOmitQueryProperty("scope", value);
    }

    @Override
    public List<String> getOmitQueryProperties() {
        return new ArrayList<String>(this.queryPropertiesOmitted);
    }

    @Override
    public boolean isOmitQueryProperty(String name) {
        return this.queryPropertiesOmitted.contains(name);
    }

    @Override
    public NDependencyFormat setOmitQueryProperty(String name, boolean value) {
        if (value) {
            this.queryPropertiesOmitted.add(name);
        } else {
            this.queryPropertiesOmitted.remove(name);
        }
        return this;
    }

    @Override
    public void print(NPrintStream out) {
        out.print(this.format());
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg aa = cmdLine.peek().get();
        if (aa == null) {
            return false;
        }
        boolean enabled = aa.isUncommented();
        switch (aa.key()) {
            case "--omit-env": {
                cmdLine.matcher().matchFlag(v -> this.setOmitOtherProperties(v.booleanValue())).anyMatch();
                return true;
            }
            case "--omit-group": {
                cmdLine.matcher().matchFlag(v -> this.setOmitGroupId(v.booleanValue())).anyMatch();
                return true;
            }
            case "--omit-imported-group": {
                cmdLine.matcher().matchFlag(v -> this.setOmitImportedGroup(v.booleanValue())).anyMatch();
                return true;
            }
            case "--omit-repo": {
                cmdLine.matcher().matchFlag(v -> this.setOmitRepository(v.booleanValue())).anyMatch();
                return true;
            }
            case "--highlight-imported-group": {
                cmdLine.matcher().matchFlag(v -> this.setHighlightImportedGroup(v.booleanValue())).anyMatch();
                return true;
            }
        }
        return false;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

