/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.EnumSet;
import java.util.Objects;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDependencyScopePattern;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.util.NFilterOp;

public class ScopeNDependencyFilter
extends AbstractDependencyFilter {
    private EnumSet<NDependencyScope> scopes = EnumSet.noneOf(NDependencyScope.class);

    public ScopeNDependencyFilter(NDependencyScopePattern ... scopes) {
        super(NFilterOp.CUSTOM);
        for (NDependencyScopePattern scope : scopes) {
            if (scope == null) continue;
            this.scopes.addAll(scope.toScopes());
        }
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        NDependencyScope d = NDependencyScope.parse(dependency.getScope()).orElse(NDependencyScope.API);
        return d != null && this.scopes.contains(d);
    }

    @Override
    public NDependencyFilter simplify() {
        if (this.scopes.isEmpty()) {
            return (NDependencyFilter)NDependencyFilters.of().always();
        }
        return this;
    }

    public String toString() {
        return "(" + this.scopes + ")";
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.scopes);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopeNDependencyFilter other = (ScopeNDependencyFilter)obj;
        return Objects.equals(this.scopes, other.scopes);
    }
}

