/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NStringUtils;

public class NExclusionDependencyFilter
extends AbstractDependencyFilter {
    private final NDependencyFilter base;
    private final NId[] exclusions;

    public NExclusionDependencyFilter(NDependencyFilter base, NId[] exclusions) {
        super(NFilterOp.CUSTOM);
        this.base = base;
        this.exclusions = exclusions;
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        if (this.base != null && !this.base.acceptDependency(dependency, from)) {
            return false;
        }
        for (NId exclusion : this.exclusions) {
            NId nutsId = dependency.toId();
            if (!GlobUtils.ofExact(exclusion.getGroupId()).matcher(NStringUtils.trim(nutsId.getGroupId())).matches() || !GlobUtils.ofExact(exclusion.getArtifactId()).matcher(NStringUtils.trim(nutsId.getArtifactId())).matches() || !exclusion.getVersion().filter().acceptVersion(nutsId.getVersion())) continue;
            return false;
        }
        return true;
    }

    @Override
    public NDependencyFilter simplify() {
        if (this.exclusions.length == 0) {
            return this.base;
        }
        NDependencyFilter base2 = CoreFilterUtils.simplify(this.base);
        if (base2 != this.base) {
            return new NExclusionDependencyFilter(base2, this.exclusions);
        }
        return this;
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.base);
        hash = 67 * hash + Arrays.deepHashCode(this.exclusions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NExclusionDependencyFilter other = (NExclusionDependencyFilter)obj;
        if (!Objects.equals(this.base, other.base)) {
            return false;
        }
        return Arrays.deepEquals(this.exclusions, other.exclusions);
    }

    public String toString() {
        return this.base + (this.exclusions == null ? "" : " excludes " + Arrays.stream(this.exclusions).map(x -> x.getLongName()).collect(Collectors.joining(",")));
    }
}

