/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDependencyScopePattern;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NFilterOp;

public class NDependencyScopeFilter
extends AbstractDependencyFilter {
    private EnumSet<NDependencyScope> scopes = EnumSet.noneOf(NDependencyScope.class);

    public NDependencyScopeFilter() {
        super(NFilterOp.CUSTOM);
    }

    private NDependencyScopeFilter(Collection<NDependencyScope> scopes) {
        super(NFilterOp.CUSTOM);
        this.scopes = EnumSet.copyOf(scopes);
    }

    public EnumSet<NDependencyScope> getScopes() {
        return this.scopes;
    }

    public NDependencyScopeFilter add(Collection<NDependencyScope> scopes) {
        if (scopes == null) {
            return this;
        }
        EnumSet<NDependencyScope> newScopes = EnumSet.copyOf(this.scopes);
        NCollections.addAllNonNull(newScopes, scopes);
        return new NDependencyScopeFilter(newScopes);
    }

    public NDependencyScopeFilter addScopePatterns(Collection<NDependencyScopePattern> scopes) {
        if (scopes == null) {
            return this;
        }
        EnumSet<NDependencyScope> s2 = EnumSet.copyOf(this.scopes);
        for (NDependencyScopePattern ss : scopes) {
            if (ss == null) continue;
            s2.addAll(ss.toScopes());
        }
        return new NDependencyScopeFilter(s2);
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        return this.scopes.isEmpty() || this.scopes.contains(NDependencyScope.parse(dependency.getScope()).orElse(NDependencyScope.API));
    }

    public String toString() {
        return CoreStringUtils.trueOrEqOrIn("scope", this.scopes.stream().map(x -> x.id()).collect(Collectors.toList()));
    }

    @Override
    public NDependencyFilter simplify() {
        return this.scopes.isEmpty() ? (NDependencyFilter)NDependencyFilters.of().always() : this;
    }
}

