/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NFilterOp;

public class NDependencyPlatformFamilyFilter
extends AbstractDependencyFilter {
    private Set<NPlatformFamily> accepted = EnumSet.noneOf(NPlatformFamily.class);

    public NDependencyPlatformFamilyFilter() {
        super(NFilterOp.CUSTOM);
    }

    private NDependencyPlatformFamilyFilter(Collection<NPlatformFamily> accepted) {
        super(NFilterOp.CUSTOM);
        this.accepted = EnumSet.copyOf(accepted);
    }

    public NDependencyPlatformFamilyFilter(String accepted) {
        super(NFilterOp.CUSTOM);
        this.accepted = EnumSet.noneOf(NPlatformFamily.class);
        for (NId e : NId.getList(accepted).get()) {
            if (e.isBlank()) continue;
            this.accepted.add(NPlatformFamily.parse(e.getArtifactId()).orNull());
        }
    }

    public NDependencyPlatformFamilyFilter add(Collection<NPlatformFamily> oses) {
        EnumSet<NPlatformFamily> s2 = EnumSet.copyOf(this.accepted);
        NCollections.addAllNonNull(s2, oses);
        return new NDependencyPlatformFamilyFilter(s2);
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        List<String> current = dependency.getCondition().getPlatform();
        boolean empty = true;
        if (current != null) {
            for (String e : current) {
                if (e.isEmpty()) continue;
                empty = false;
                if (!this.accepted.contains(NPlatformFamily.parse(e).orNull())) continue;
                return true;
            }
        }
        return empty;
    }

    public String toString() {
        return CoreStringUtils.trueOrEqOrIn("platform", this.accepted.stream().map(x -> x.id()).collect(Collectors.toList()));
    }

    @Override
    public NDependencyFilter simplify() {
        return this.accepted.isEmpty() ? (NDependencyFilter)NDependencyFilters.of().always() : this;
    }
}

