/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NStream;

public class NDependencyOsDistIdFilter
extends AbstractDependencyFilter {
    private Set<NId> accepted = new HashSet<NId>();

    public NDependencyOsDistIdFilter() {
        super(NFilterOp.CUSTOM);
    }

    private NDependencyOsDistIdFilter(Collection<NId> accepted) {
        super(NFilterOp.CUSTOM);
        this.accepted = new LinkedHashSet<NId>(accepted);
    }

    public NDependencyOsDistIdFilter add(Collection<NId> oses) {
        LinkedHashSet<NId> s2 = new LinkedHashSet<NId>(this.accepted);
        NCollections.addAllNonNull(s2, oses);
        return new NDependencyOsDistIdFilter(s2);
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        List<String> current = NStream.ofIterable(dependency.getCondition().getOsDist()).filterNonBlank().toList();
        if (current.size() == 0 || this.accepted.isEmpty()) {
            return true;
        }
        for (NId nutsId : this.accepted) {
            if (!CoreFilterUtils.matchesOsDist(nutsId.toString(), current)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return CoreStringUtils.trueOrEqOrIn("os", this.accepted.stream().map(x -> x.toString()).collect(Collectors.toList()));
    }

    @Override
    public NDependencyFilter simplify() {
        return this.accepted.isEmpty() ? (NDependencyFilter)NDependencyFilters.of().always() : this;
    }
}

