/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NDependencyOptionalFilter
extends AbstractDependencyFilter {
    private final Boolean optional;

    public NDependencyOptionalFilter(Boolean optional) {
        super(NFilterOp.CUSTOM);
        this.optional = optional;
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        if (this.optional == null) {
            return false;
        }
        return this.optional.booleanValue() == dependency.isOptional();
    }

    @Override
    public NDependencyFilter simplify() {
        if (this.optional == null) {
            return null;
        }
        return this;
    }

    public String toString() {
        if (this.optional == null) {
            return "any optional";
        }
        return this.optional != false ? "optional" : "not(optional)";
    }
}

