/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NFilterOp;

public class NDependencyDEFilter
extends AbstractDependencyFilter {
    private Set<NDesktopEnvironmentFamily> accepted = EnumSet.noneOf(NDesktopEnvironmentFamily.class);

    public NDependencyDEFilter() {
        super(NFilterOp.CUSTOM);
    }

    private NDependencyDEFilter(Collection<NDesktopEnvironmentFamily> accepted) {
        super(NFilterOp.CUSTOM);
        this.accepted = EnumSet.copyOf(accepted);
    }

    public NDependencyDEFilter(String accepted) {
        super(NFilterOp.CUSTOM);
        this.accepted = EnumSet.noneOf(NDesktopEnvironmentFamily.class);
        for (String e : StringTokenizerUtils.splitDefault(accepted)) {
            if (e.isEmpty()) continue;
            this.accepted.add(NDesktopEnvironmentFamily.parse(e).orNull());
        }
    }

    public NDependencyDEFilter add(Collection<NDesktopEnvironmentFamily> oses) {
        EnumSet<NDesktopEnvironmentFamily> s2 = EnumSet.copyOf(this.accepted);
        NCollections.addAllNonNull(s2, oses);
        return new NDependencyDEFilter(s2);
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        if (this.accepted.isEmpty()) {
            return true;
        }
        List<String> current = dependency.getCondition().getDesktopEnvironment();
        if (current != null) {
            List currentFamilies = current.stream().map(e -> {
                NId de;
                if (!e.isEmpty() && (de = NId.get(e).orNull()) != null) {
                    return NDesktopEnvironmentFamily.parse(de.getArtifactId()).orNull();
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            if (currentFamilies.isEmpty()) {
                return true;
            }
            for (NDesktopEnvironmentFamily currentFamily : currentFamilies) {
                if (!this.accepted.contains(currentFamily)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return CoreStringUtils.trueOrEqOrIn("desktopEnvironment", this.accepted.stream().map(NDesktopEnvironmentFamily::id).collect(Collectors.toList()));
    }

    @Override
    public NDependencyFilter simplify() {
        return this.accepted.isEmpty() ? (NDependencyFilter)NDependencyFilters.of().always() : this;
    }
}

