/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.List;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyTreeNode;

public class DefaultNDependencyTreeNode
implements NDependencyTreeNode {
    public static final long serialVersionUID = 1L;
    private final NDependency dependency;
    private final List<NDependencyTreeNode> children;
    private final boolean partial;
    private final boolean optional;
    private final boolean provided;

    public DefaultNDependencyTreeNode(NDependency dependency, List<NDependencyTreeNode> children, boolean partial, boolean optional, boolean provided) {
        this.dependency = dependency;
        this.children = children;
        this.partial = partial;
        this.optional = optional;
        this.provided = provided;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isProvided() {
        return this.provided;
    }

    @Override
    public NDependency getDependency() {
        return this.dependency;
    }

    @Override
    public List<NDependencyTreeNode> getChildren() {
        return this.children;
    }

    @Override
    public boolean isPartial() {
        return this.partial;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.dependency.toString());
        if (this.partial) {
            if (s.indexOf("?") >= 0) {
                s.append("&partial=true");
            } else {
                s.append("?partial=true");
            }
        }
        if (this.optional) {
            if (s.indexOf("?") >= 0) {
                s.append("&optional=true");
            } else {
                s.append("?optional=true");
            }
        }
        if (this.provided) {
            if (s.indexOf("?") >= 0) {
                s.append("&provided=true");
            } else {
                s.append("?provided=true");
            }
        }
        if (!this.children.isEmpty()) {
            if (s.indexOf("?") >= 0) {
                s.append("&children-count=").append(this.children.size());
            } else {
                s.append("?children-count=").append(this.children.size());
            }
        }
        return s.toString();
    }
}

