/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.List;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NutsAPIDefinitionFilter
extends AbstractDefinitionFilter {
    private final NVersion apiVersion;

    public NutsAPIDefinitionFilter(NVersion apiVersion) {
        super(NFilterOp.CUSTOM);
        this.apiVersion = apiVersion;
    }

    @Override
    public boolean acceptDefinition(NDefinition definition) {
        for (NDependency dependency : definition.getDescriptor().getDependencies()) {
            if (!dependency.getShortName().equals("net.thevpc.nuts:nuts")) continue;
            return this.apiVersion.filter().acceptVersion(dependency.getVersion());
        }
        List<NDependency> allDeps = NFetchCmd.of(definition.getId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition().getDependencies().get().transitive().toList();
        for (NDependency dependency : allDeps) {
            if (!dependency.getShortName().equals("net.thevpc.nuts:nuts")) continue;
            return this.apiVersion.filter().acceptVersion(dependency.getVersion());
        }
        return false;
    }

    public String toString() {
        return "NutsAPI(" + this.apiVersion + ')';
    }

    @Override
    public NDefinitionFilter simplify() {
        return this;
    }
}

