/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;

public class NLockedIdExtensionDefinitionFilter
extends AbstractDefinitionFilter {
    private NId[] lockedIds;

    public NLockedIdExtensionDefinitionFilter(NId[] lockedIds) {
        super(NFilterOp.CUSTOM);
        this.lockedIds = lockedIds;
    }

    public boolean acceptId(NId id) {
        for (NId nutsId : this.lockedIds) {
            if (!nutsId.getShortId().equalsShortId(id.getShortId())) continue;
            return id.getVersion().filter().acceptVersion(nutsId.getVersion());
        }
        return true;
    }

    @Override
    public boolean acceptDefinition(NDefinition other) {
        if (!this.acceptId(other.getId())) {
            return false;
        }
        for (NDependency dependency : other.getDescriptor().getDependencies()) {
            if (this.acceptId(dependency.toId())) continue;
            return false;
        }
        return true;
    }

    @Override
    public NDefinitionFilter simplify() {
        return this;
    }

    public String toString() {
        return "LockedIds(" + Arrays.stream(this.lockedIds).map(NId::getLongName).collect(Collectors.joining(",")) + ")";
    }

    public NLockedIdExtensionDefinitionFilter addAll(NId[] others) {
        NId[] validIds = others == null ? new NId[]{} : Arrays.stream(others).filter(x -> NBlankable.isBlank(x)).collect(Collectors.toSet()).toArray(new NId[0]);
        HashSet<NId> old0 = new HashSet<NId>(Arrays.asList(this.lockedIds));
        HashSet<NId> old1 = new HashSet<NId>(old0);
        old1.addAll(Arrays.asList(validIds));
        if (old1.equals(old0)) {
            return this;
        }
        return new NLockedIdExtensionDefinitionFilter(old1.toArray(new NId[0]));
    }
}

