/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFlagsIdFilter
extends AbstractDefinitionFilter {
    private final Set<NDescriptorFlag> flags = new LinkedHashSet<NDescriptorFlag>();
    private final boolean effectiveFlag;

    public NDefinitionFlagsIdFilter(boolean effectiveFlag, NDescriptorFlag ... flags) {
        super(NFilterOp.CUSTOM);
        this.effectiveFlag = effectiveFlag;
        for (NDescriptorFlag flag : flags) {
            if (flag == null) continue;
            this.flags.add(flag);
        }
    }

    @Override
    public boolean acceptDefinition(NDefinition other) {
        Set<NDescriptorFlag> available = other.getDescriptor().getFlags();
        if (this.effectiveFlag) {
            for (NDescriptorFlag nDescriptorFlag : this.flags) {
                if (available.contains(nDescriptorFlag)) continue;
                return false;
            }
            Set<NDescriptorFlag> af = other.getEffectiveFlags().get();
            for (NDescriptorFlag flag : this.flags) {
                if (af.contains(flag)) continue;
                return false;
            }
        } else {
            for (NDescriptorFlag nDescriptorFlag : this.flags) {
                if (available.contains(nDescriptorFlag)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public NDefinitionFilter simplify() {
        if (this.flags.isEmpty()) {
            return null;
        }
        return this;
    }

    public String toString() {
        if (this.flags.isEmpty()) {
            return "any";
        }
        if (this.effectiveFlag) {
            if (this.flags.size() == 1) {
                return "hasEffectiveFlag(" + this.flags.toArray(new NDescriptorFlag[0])[0].id() + ")";
            }
            return "hasEffectiveFlag(" + this.flags.stream().map(NDescriptorFlag::id).collect(Collectors.joining(",")) + ")";
        }
        if (this.flags.size() == 1) {
            return "hasFlag(" + this.flags.toArray(new NDescriptorFlag[0])[0].id() + ")";
        }
        return "hasFlags(" + this.flags.stream().map(NDescriptorFlag::id).collect(Collectors.joining(",")) + ")";
    }
}

