/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFilterPackaging
extends AbstractDefinitionFilter {
    private final String packaging;

    public NDefinitionFilterPackaging(String packaging) {
        super(NFilterOp.CUSTOM);
        this.packaging = packaging;
    }

    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean acceptDefinition(NDefinition descriptor) {
        return CoreFilterUtils.matchesPackaging(this.packaging, descriptor.getDescriptor());
    }

    @Override
    public NDefinitionFilter simplify() {
        if (NBlankable.isBlank(this.packaging)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.packaging);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionFilterPackaging other = (NDefinitionFilterPackaging)obj;
        return Objects.equals(this.packaging, other.packaging);
    }

    public String toString() {
        return "Packaging{" + this.packaging + '}';
    }
}

