/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.dependency.util.NComplexExpressionString;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFilterOr
extends AbstractDefinitionFilter
implements NComplexExpressionString {
    private NDefinitionFilter[] all;

    public NDefinitionFilterOr(NDefinitionFilter ... all) {
        super(NFilterOp.OR);
        LinkedHashSet<NDefinitionFilter> valid = new LinkedHashSet<NDefinitionFilter>();
        if (all != null) {
            for (NDefinitionFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NDefinitionFilter[0]);
    }

    public NDefinitionFilter[] getChildren() {
        return Arrays.copyOf(this.all, this.all.length);
    }

    @Override
    public boolean acceptDefinition(NDefinition id) {
        if (this.all.length == 0) {
            return true;
        }
        for (NDefinitionFilter filter : this.all) {
            if (!filter.acceptDefinition(id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NDefinitionFilter simplify() {
        return CoreFilterUtils.simplifyFilterOr(NDefinitionFilter.class, this, this.all);
    }

    public String toString() {
        return CoreStringUtils.trueOrOr(Arrays.stream(this.all).map(NComplexExpressionString::toString).collect(Collectors.toList()));
    }

    @Override
    public List<NFilter> getSubFilters() {
        return Arrays.asList(this.all);
    }
}

