/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFilterArch
extends AbstractDefinitionFilter {
    private final String arch;

    public NDefinitionFilterArch(String packaging) {
        super(NFilterOp.CUSTOM);
        this.arch = packaging;
    }

    public String getArch() {
        return this.arch;
    }

    @Override
    public boolean acceptDefinition(NDefinition definition) {
        return CoreFilterUtils.matchesArch(this.arch, definition.getDescriptor().getCondition().getArch());
    }

    @Override
    public NDefinitionFilter simplify() {
        if (NBlankable.isBlank(this.arch)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.arch);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionFilterArch other = (NDefinitionFilterArch)obj;
        return Objects.equals(this.arch, other.arch);
    }

    public String toString() {
        return "Arch{" + this.arch + '}';
    }
}

