/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionBuilder;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionWithSuppliers;
import net.thevpc.nuts.runtime.standalone.util.ValueSupplier;

public class DefaultNDefinitionBuilder2 {
    private Supplier<NId> id;
    private Supplier<NDescriptor> descriptor;
    private Supplier<String> repositoryUuid;
    private Supplier<String> repositoryName;
    private Supplier<NPath> content;
    private Supplier<NInstallInformation> installInformation;
    private Supplier<NDependencies> dependencies;
    private Supplier<NDescriptor> effectiveDescriptor;
    private Supplier<NDependency> dependency;
    private Supplier<NId> apiId = null;
    private Supplier<Set<NDescriptorFlag>> effectiveFlags;

    public DefaultNDefinitionBuilder2() {
    }

    public DefaultNDefinitionBuilder2(NDefinition other) {
        if (other != null) {
            if (other instanceof DefaultNDefinitionWithSuppliers) {
                DefaultNDefinitionWithSuppliers ds = (DefaultNDefinitionWithSuppliers)other;
                this.descriptor = ds.descriptor;
                this.id = ds.id;
                this.repositoryUuid = ds.repositoryUuid;
                this.repositoryName = ds.repositoryName;
                this.content = ds.content;
                this.installInformation = ds.installInformation;
                this.effectiveDescriptor = ds.effectiveDescriptor;
                this.dependencies = ds.dependencies;
                this.apiId = ds.apiId;
                this.dependency = ds.dependency;
                this.effectiveFlags = ds.effectiveFlags;
            } else {
                this.descriptor = new ValueSupplier<NDescriptor>(other.getDescriptor());
                this.id = new ValueSupplier<NId>(other.getId());
                this.repositoryUuid = new ValueSupplier<String>(other.getRepositoryUuid());
                this.repositoryName = new ValueSupplier<String>(other.getRepositoryName());
                this.content = () -> other.getContent().orNull();
                this.installInformation = () -> other.getInstallInformation().orNull();
                this.effectiveDescriptor = () -> other.getEffectiveDescriptor().orNull();
                this.dependencies = () -> other.getDependencies().orNull();
                this.apiId = () -> other.getApiId();
                this.dependency = () -> other.getDependency();
                this.effectiveFlags = () -> other.getEffectiveFlags().orNull();
            }
        }
    }

    public DefaultNDefinitionBuilder2(DefaultNDefinitionBuilder2 other) {
        if (other != null) {
            this.descriptor = other.descriptor;
            this.id = other.id;
            this.repositoryUuid = other.repositoryUuid;
            this.repositoryName = other.repositoryName;
            this.content = other.content;
            this.installInformation = other.installInformation;
            this.effectiveDescriptor = other.effectiveDescriptor;
            this.dependencies = other.dependencies;
            this.apiId = other.apiId;
            this.dependency = other.dependency;
            this.effectiveFlags = other.effectiveFlags;
        }
    }

    public Supplier<NDependency> getDependency() {
        return this.dependency;
    }

    public DefaultNDefinitionBuilder2 setDependency(Supplier<NDependency> dependency) {
        this.dependency = dependency;
        return this;
    }

    public NDefinition build() {
        return new DefaultNDefinitionWithSuppliers(this.repositoryUuid, this.repositoryName, this.id, this.descriptor, this.content, this.installInformation, this.apiId, this.effectiveDescriptor, this.dependencies, this.dependency, this.effectiveFlags);
    }

    public Supplier<String> getRepositoryUuid() {
        return this.repositoryUuid;
    }

    public Supplier<String> getRepositoryName() {
        return this.repositoryName;
    }

    public DefaultNDefinitionBuilder2 setId(Supplier<NId> id) {
        this.id = id;
        return this;
    }

    public Supplier<NId> getId() {
        return this.id;
    }

    public Supplier<NDescriptor> getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "Definition{ id=" + this.id + ", content=" + this.content + '}';
    }

    public DefaultNDefinitionBuilder2 copy() {
        return new DefaultNDefinitionBuilder2(this);
    }

    public Supplier<NPath> getContent() {
        return this.content;
    }

    public Supplier<NDescriptor> getEffectiveDescriptor() {
        return this.effectiveDescriptor;
    }

    public Supplier<NInstallInformation> getInstallInformation() {
        return this.installInformation;
    }

    public Supplier<NDependencies> getDependencies() {
        return this.dependencies;
    }

    public DefaultNDefinitionBuilder2 setContent(Supplier<NPath> content) {
        this.content = content;
        return this;
    }

    public DefaultNDefinitionBuilder2 setDescriptor(Supplier<NDescriptor> descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionBuilder other = (NDefinitionBuilder)obj;
        return Objects.equals(this.id, other.getId());
    }

    public DefaultNDefinitionBuilder2 setEffectiveDescriptor(Supplier<NDescriptor> effectiveDescriptor) {
        this.effectiveDescriptor = effectiveDescriptor;
        return this;
    }

    public DefaultNDefinitionBuilder2 setInstallInformation(Supplier<NInstallInformation> install) {
        this.installInformation = install;
        return this;
    }

    public DefaultNDefinitionBuilder2 setDependencies(Supplier<NDependencies> dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public DefaultNDefinitionBuilder2 setApiId(Supplier<NId> apiId) {
        this.apiId = apiId;
        return this;
    }

    public Supplier<NId> getApiId() {
        return this.apiId;
    }

    public DefaultNDefinitionBuilder2 setRepositoryUuid(Supplier<String> repositoryUuid) {
        this.repositoryUuid = repositoryUuid;
        return this;
    }

    public DefaultNDefinitionBuilder2 setRepositoryName(Supplier<String> repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public DefaultNDefinitionBuilder2 setEffectiveFlags(Supplier<Set<NDescriptorFlag>> effectiveFlags) {
        this.effectiveFlags = effectiveFlags;
        return this;
    }
}

