/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionBuilder;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionBuilder;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NImmutable;
import net.thevpc.nuts.util.NOptional;

public class DefaultNDefinition
implements NDefinition,
NImmutable {
    private final NId id;
    private final NDescriptor descriptor;
    private final String repositoryUuid;
    private final String repositoryName;
    private final NPath content;
    private final NInstallInformation installInformation;
    private final NDependencies dependencies;
    private final NDescriptor effectiveDescriptor;
    private final NId apiId;
    private final NDependency dependency;
    private final Set<NDescriptorFlag> effectiveFlags;

    public DefaultNDefinition() {
        this.descriptor = null;
        this.id = null;
        this.repositoryUuid = null;
        this.repositoryName = null;
        this.content = null;
        this.installInformation = null;
        this.effectiveDescriptor = null;
        this.dependencies = null;
        this.apiId = null;
        this.dependency = null;
        this.effectiveFlags = Collections.emptySet();
    }

    public DefaultNDefinition(String repoUuid, String repoName, NId id, NDescriptor descriptor, NPath content, NInstallInformation install, NId apiId, NDescriptor effectiveDescriptor, NDependencies dependencies, NDependency dependency, Set<NDescriptorFlag> effectiveFlags) {
        this.id = id;
        this.descriptor = descriptor;
        this.content = content;
        if (!id.isLongId()) {
            throw new NIllegalArgumentException(NMsg.ofC("id should not have query defined in descriptors : %s", id));
        }
        this.installInformation = install;
        this.repositoryUuid = repoUuid;
        this.repositoryName = repoName;
        this.apiId = apiId;
        this.effectiveDescriptor = effectiveDescriptor;
        this.dependencies = dependencies;
        this.dependency = dependency;
        this.effectiveFlags = effectiveFlags == null ? null : Collections.unmodifiableSet(new HashSet<NDescriptorFlag>(effectiveFlags));
    }

    public DefaultNDefinition(NDefinition other) {
        if (other != null) {
            this.descriptor = other.getDescriptor();
            this.id = other.getId();
            this.repositoryUuid = other.getRepositoryUuid();
            this.repositoryName = other.getRepositoryName();
            this.content = other.getContent().orNull();
            this.installInformation = other.getInstallInformation().orNull();
            this.effectiveDescriptor = other.getEffectiveDescriptor().orNull();
            this.dependencies = other.getDependencies().orNull();
            this.apiId = other.getApiId();
            this.dependency = other.getDependency();
            this.effectiveFlags = other.getEffectiveFlags().orNull();
        } else {
            this.descriptor = null;
            this.id = null;
            this.repositoryUuid = null;
            this.repositoryName = null;
            this.content = null;
            this.installInformation = null;
            this.effectiveDescriptor = null;
            this.dependencies = null;
            this.apiId = null;
            this.dependency = null;
            this.effectiveFlags = null;
        }
    }

    @Override
    public NDependency getDependency() {
        return this.dependency;
    }

    @Override
    public String getRepositoryUuid() {
        return this.repositoryUuid;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public NDefinitionBuilder builder() {
        return new DefaultNDefinitionBuilder(this);
    }

    @Override
    public NId getId() {
        return this.id;
    }

    public boolean isTemporary() {
        return this.content != null && this.content.isUserTemporary();
    }

    @Override
    public NDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "Definition{ id=" + this.id + ", content=" + this.content + '}';
    }

    @Override
    public NOptional<NPath> getContent() {
        return NOptional.of(this.content, () -> NMsg.ofC("content not found for id %s", this.getId()));
    }

    @Override
    public NOptional<NDescriptor> getEffectiveDescriptor() {
        return NOptional.of(this.effectiveDescriptor, () -> NMsg.ofC("unable to get effectiveDescriptor for id %s. You need to call search.setEffective(...) first.", this.getId()));
    }

    @Override
    public NOptional<NInstallInformation> getInstallInformation() {
        return NOptional.of(this.installInformation, () -> NMsg.ofC("unable to get install information for id %s.", this.getId()));
    }

    @Override
    public NOptional<NDependencies> getDependencies() {
        return NOptional.of(this.dependencies, () -> NMsg.ofC("unable to get dependencies for id %s. You need to call search.setDependencies(...) first.", this.getId()));
    }

    @Override
    public NOptional<Set<NDescriptorFlag>> getEffectiveFlags() {
        return NOptional.of(this.effectiveFlags, () -> NMsg.ofC("unable to get effectiveFlags", this.getId()));
    }

    @Override
    public int compareTo(NDefinition n2) {
        if (n2 == null) {
            return 1;
        }
        if (!(n2 instanceof DefaultNDefinition)) {
            return -1;
        }
        NId o1 = this.getId();
        NId o2 = n2.getId();
        if (o1 == null || o2 == null) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            return 1;
        }
        return o1.compareTo(o2);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNDefinition other = (DefaultNDefinition)obj;
        return Objects.equals(this.id, other.id);
    }

    @Override
    public NId getApiId() {
        return this.apiId;
    }
}

