/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.time.Instant;
import net.thevpc.nuts.concurrent.NWorkBalancerJob;
import net.thevpc.nuts.concurrent.NWorkBalancerRunningJob;
import net.thevpc.nuts.time.NDuration;

class WorkBalancerRunningJob<T>
implements NWorkBalancerRunningJob {
    private final NWorkBalancerJob<T> job;
    private final String jobName;
    private final String jobId;
    private final String workerName;
    private final long startNano;
    private long endNano;
    private Throwable throwable;

    public WorkBalancerRunningJob(NWorkBalancerJob<T> job, String jobId, String jobName, String workerName, long startNano) {
        this.job = job;
        this.jobId = jobId;
        this.workerName = workerName;
        this.startNano = startNano;
        this.jobName = jobName;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public Instant getStartTime() {
        return Instant.ofEpochMilli(this.startNano / 1000000L);
    }

    @Override
    public long getStartTimeNano() {
        return this.startNano;
    }

    @Override
    public long getEndTimeNano() {
        return this.endNano;
    }

    @Override
    public NDuration getDuration() {
        long now = (this.endNano > 0L ? this.endNano : System.nanoTime()) - this.startNano;
        return NDuration.ofNanos(now);
    }

    @Override
    public String getWorkerName() {
        return this.workerName;
    }

    public void setEndNano(long endNano) {
        this.endNano = endNano;
    }

    public WorkBalancerRunningJob<T> setThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    @Override
    public boolean isRunning() {
        return this.endNano == 0L;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }
}

