/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategy;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategyContext;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategyEvent;
import net.thevpc.nuts.concurrent.NWorkBalancerWorker;

class RoundRobin
implements NWorkBalancerStrategy {
    private final AtomicInteger counter = new AtomicInteger(0);

    RoundRobin() {
    }

    @Override
    public void onStartCall(NWorkBalancerStrategyEvent event) {
    }

    @Override
    public void onEndCall(NWorkBalancerStrategyEvent event) {
    }

    @Override
    public String selectWorker(NWorkBalancerStrategyContext context) {
        List<NWorkBalancerWorker> workers = context.getWorkers();
        if (workers.isEmpty()) {
            throw new IllegalStateException("No workers available for load balancing");
        }
        float totalWeight = 0.0f;
        for (NWorkBalancerWorker w : workers) {
            totalWeight += Math.max(0.0f, w.getWeight());
        }
        if (totalWeight <= 0.0f) {
            int index = Math.floorMod(this.counter.getAndIncrement(), workers.size());
            return workers.get(index).getName();
        }
        float position = (float)this.counter.getAndIncrement() % totalWeight;
        float cumulative = 0.0f;
        for (NWorkBalancerWorker w : workers) {
            if (!(position < (cumulative += Math.max(0.0f, w.getWeight())))) continue;
            return w.getName();
        }
        return workers.get(workers.size() - 1).getName();
    }
}

