/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategy;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategyContext;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategyEvent;
import net.thevpc.nuts.concurrent.NWorkBalancerWorker;
import net.thevpc.nuts.concurrent.NWorkBalancerWorkerLoad;

class PowerOfTwoLoad
implements NWorkBalancerStrategy {
    private final AtomicInteger rrCounter = new AtomicInteger(0);
    private final Random random = new Random();

    PowerOfTwoLoad() {
    }

    @Override
    public void onStartCall(NWorkBalancerStrategyEvent event) {
    }

    @Override
    public void onEndCall(NWorkBalancerStrategyEvent event) {
    }

    @Override
    public String selectWorker(NWorkBalancerStrategyContext context) {
        double load2;
        List<NWorkBalancerWorker> workers = context.getWorkers();
        if (workers.isEmpty()) {
            throw new IllegalStateException("No workers available");
        }
        NWorkBalancerWorker w1 = this.pickRandomWorker(workers);
        NWorkBalancerWorker w2 = this.pickRandomWorker(workers);
        double load1 = this.resolveEffectiveLoad(w1, context);
        if (Double.compare(load1, load2 = this.resolveEffectiveLoad(w2, context)) < 0) {
            return w1.getName();
        }
        if (Double.compare(load2, load1) < 0) {
            return w2.getName();
        }
        return this.rrCounter.getAndIncrement() % 2 == 0 ? w1.getName() : w2.getName();
    }

    private NWorkBalancerWorker pickRandomWorker(List<NWorkBalancerWorker> workers) {
        NWorkBalancerWorker w;
        int tries = 0;
        while ((w = workers.get(this.random.nextInt(workers.size()))).getWeight() <= 0.0f && ++tries < 10) {
        }
        if (w.getWeight() <= 0.0f) {
            w = workers.get(this.random.nextInt(workers.size()));
        }
        return w;
    }

    private double resolveEffectiveLoad(NWorkBalancerWorker worker, NWorkBalancerStrategyContext context) {
        float hostLoad;
        double loadValue = 0.0;
        NWorkBalancerWorkerLoad load = context.getWorkerLoad(worker.getName()).orNull();
        if (load != null && !Float.isNaN(hostLoad = load.hostLoadMetrics().get().getHostLoadFactor())) {
            loadValue = hostLoad;
        }
        float weight = worker.getWeight() > 0.0f ? worker.getWeight() : 1.0f;
        return loadValue / (double)weight;
    }
}

