/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NWorkBalancer;
import net.thevpc.nuts.concurrent.NWorkBalancerJob;
import net.thevpc.nuts.concurrent.NWorkBalancerModel;
import net.thevpc.nuts.concurrent.NWorkBalancerRunningJob;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategy;
import net.thevpc.nuts.concurrent.NWorkBalancerWorker;
import net.thevpc.nuts.concurrent.NWorkBalancerWorkerLoad;
import net.thevpc.nuts.concurrent.NWorkBalancerWorkerModel;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.runtime.standalone.concurrent.NCallableFromJob;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerWorkerImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerWorkerLoadImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.WorkBalancerStrategyContextImpl;
import net.thevpc.nuts.util.NOptional;

public class NWorkBalancerImpl<T>
implements NWorkBalancer<T> {
    final NWorkBalancerStrategy strategy;
    final List<NWorkBalancerRunningJob> runningJobs = Collections.synchronizedList(new ArrayList());
    private final NWorkBalancerFactoryImpl factory;
    final NWorkBalancerModel model;
    private final Map<String, NWorkBalancerWorkerLoadImpl> workBalancerWorkerLoadMap = new HashMap<String, NWorkBalancerWorkerLoadImpl>();
    private final Map<String, NWorkBalancerWorkerModel> workBalancerWorkerModelMap = new HashMap<String, NWorkBalancerWorkerModel>();

    public NWorkBalancerImpl(NWorkBalancerModel model, NWorkBalancerFactoryImpl factory) {
        this.model = model;
        this.strategy = factory.createStrategy(model.getStrategy());
        this.factory = factory;
        this._updateModel();
    }

    private void _updateModel() {
        this.workBalancerWorkerLoadMap.clear();
        this.workBalancerWorkerModelMap.clear();
        if (this.model.getWorkers() != null) {
            int workerIndex = 0;
            for (NWorkBalancerWorkerModel w : this.model.getWorkers()) {
                this.workBalancerWorkerModelMap.put(w.getName(), w);
                this.workBalancerWorkerLoadMap.put(w.getName(), new NWorkBalancerWorkerLoadImpl(w, workerIndex));
                ++workerIndex;
            }
        }
    }

    @Override
    public NCallable<T> of(String name, NWorkBalancerJob<T> job) {
        return new NCallableFromJob<T>(this, name, job);
    }

    NWorkBalancerWorkerLoadImpl selectWorker() {
        WorkBalancerStrategyContextImpl w = new WorkBalancerStrategyContextImpl(this.model, this);
        String s = this.strategy.selectWorker(w);
        return NOptional.ofNamed(this.workBalancerWorkerLoadMap.get(s), s).get();
    }

    @Override
    public List<NWorkBalancerRunningJob> getRunningJobs() {
        return Collections.unmodifiableList(new ArrayList<NWorkBalancerRunningJob>(this.runningJobs));
    }

    @Override
    public boolean hasRunningJobs() {
        return !this.runningJobs.isEmpty();
    }

    @Override
    public int getRunningJobsCount() {
        return this.runningJobs.size();
    }

    @Override
    public List<NWorkBalancerWorker> getWorkers() {
        if (this.model.getWorkers() == null) {
            return Collections.emptyList();
        }
        return this.model.getWorkers().stream().map(NWorkBalancerWorkerImpl::new).collect(Collectors.toList());
    }

    @Override
    public NOptional<NWorkBalancerWorkerLoad> getWorkerLoad(String workerName) {
        NWorkBalancerWorkerLoadImpl worker = this.workBalancerWorkerLoadMap.get(workerName);
        return NOptional.ofNamed(worker, workerName);
    }

    @Override
    public Map<String, NWorkBalancerWorkerLoad> getWorkerLoads() {
        if (this.model.getWorkers() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, NWorkBalancerWorkerLoad> map = new HashMap<String, NWorkBalancerWorkerLoad>();
        for (NWorkBalancerWorkerModel w : this.model.getWorkers()) {
            this.getWorkerLoad(w.getName()).ifPresent(l -> map.put(w.getName(), (NWorkBalancerWorkerLoad)l));
        }
        return map;
    }

    @Override
    public NOptional<NElement> getOption(String name) {
        if (this.model.getOptions() != null && this.model.getOptions().containsKey(name)) {
            return NOptional.of(this.model.getOptions().get(name));
        }
        return NOptional.ofEmpty();
    }

    @Override
    public Map<String, NElement> getOptions() {
        return this.model.getOptions() != null ? Collections.unmodifiableMap(this.model.getOptions()) : Collections.emptyMap();
    }
}

