/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.concurrent.NWorkBalancer;
import net.thevpc.nuts.concurrent.NWorkBalancerBuilder;
import net.thevpc.nuts.concurrent.NWorkBalancerDefaultStrategy;
import net.thevpc.nuts.concurrent.NWorkBalancerHostLoadMetricProvider;
import net.thevpc.nuts.concurrent.NWorkBalancerModel;
import net.thevpc.nuts.concurrent.NWorkBalancerWorkerModel;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NIllegalStateException;
import net.thevpc.nuts.util.NStringUtils;

public class NWorkBalancerBuilderImpl<T>
implements NWorkBalancerBuilder<T> {
    private final String id;
    private final List<NWorkBalancerWorkerModel> workers = new ArrayList<NWorkBalancerWorkerModel>();
    private String strategy;
    private final Map<String, NElement> options = new HashMap<String, NElement>();
    private final NWorkBalancerFactoryImpl factory;

    public NWorkBalancerBuilderImpl(String id, NWorkBalancerFactoryImpl factory) {
        this.id = id;
        this.factory = factory;
    }

    @Override
    public NWorkBalancerBuilder.WorkerBuilder<T> addWorker(String workerName) {
        String validWorkerName = NStringUtils.trimToNull(workerName);
        NAssert.requireFalse(this.workers.stream().filter(x -> Objects.equals(x.getName(), validWorkerName)).findFirst().isPresent(), () -> NMsg.ofC("duplicate worker name : %s", validWorkerName));
        NWorkBalancerWorkerModel worker = new NWorkBalancerWorkerModel().setName(validWorkerName).setWeight(1.0f);
        this.workers.add(worker);
        return new WorkerBuilderImpl(this, worker);
    }

    @Override
    public NWorkBalancerBuilder<T> remove(String workerName) {
        this.workers.removeIf(w -> workerName.equals(w.getName()));
        return this;
    }

    @Override
    public NWorkBalancerBuilder<T> setStrategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    @Override
    public NWorkBalancerBuilder<T> setStrategy(NWorkBalancerDefaultStrategy strategy) {
        this.strategy = strategy == null ? null : strategy.id();
        return this;
    }

    @Override
    public NWorkBalancerBuilder<T> setOption(String optionName, NElement optionValue) {
        this.options.put(optionName, optionValue);
        return this;
    }

    @Override
    public NWorkBalancer<T> build() {
        if (this.workers.isEmpty()) {
            throw new NIllegalStateException(NMsg.ofC("No workers defined"));
        }
        NWorkBalancerModel model = new NWorkBalancerModel();
        model.setId(this.id);
        model.setWorkers(new ArrayList<NWorkBalancerWorkerModel>(this.workers).stream().map(x -> x.copy()).collect(Collectors.toList()));
        model.setStrategy(this.strategy);
        model.setOptions(new HashMap<String, NElement>(this.options));
        return new NWorkBalancerImpl(model, this.factory);
    }

    private static class WorkerBuilderImpl<T>
    implements NWorkBalancerBuilder.WorkerBuilder<T> {
        private final NWorkBalancerBuilderImpl<T> parent;
        private final NWorkBalancerWorkerModel worker;

        WorkerBuilderImpl(NWorkBalancerBuilderImpl<T> parent, NWorkBalancerWorkerModel worker) {
            this.parent = parent;
            this.worker = worker;
        }

        @Override
        public NWorkBalancerBuilder.WorkerBuilder<T> withWeight(float weight) {
            this.worker.setWeight(weight);
            return this;
        }

        @Override
        public NWorkBalancerBuilder.WorkerBuilder<T> withOption(String optionName, NElement optionValue) {
            if (this.worker.getOptions() == null) {
                this.worker.setOptions(new HashMap<String, NElement>());
            }
            this.worker.getOptions().put(optionName, optionValue);
            return this;
        }

        @Override
        public NWorkBalancerBuilder.WorkerBuilder<T> withHostLoadMetricsProvider(NWorkBalancerHostLoadMetricProvider hostLoadMetricsProvider) {
            this.worker.setHostLoadMetricsProvider(hostLoadMetricsProvider);
            return this;
        }

        @Override
        public NWorkBalancerBuilder<T> then() {
            return this.parent;
        }

        @Override
        public NWorkBalancerBuilder.WorkerBuilder<T> addWorker(String workerName) {
            return this.then().addWorker(workerName);
        }

        @Override
        public NWorkBalancer<T> build() {
            return this.then().build();
        }
    }
}

