/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.stream.Collectors;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NCompensationStrategy;
import net.thevpc.nuts.concurrent.NRunnable;
import net.thevpc.nuts.concurrent.NSagaCallable;
import net.thevpc.nuts.concurrent.NSagaCondition;
import net.thevpc.nuts.concurrent.NSagaContext;
import net.thevpc.nuts.concurrent.NSagaContextModel;
import net.thevpc.nuts.concurrent.NSagaModel;
import net.thevpc.nuts.concurrent.NSagaNodeModel;
import net.thevpc.nuts.concurrent.NSagaNodeStatus;
import net.thevpc.nuts.concurrent.NSagaNodeType;
import net.thevpc.nuts.concurrent.NSagaStatus;
import net.thevpc.nuts.concurrent.NSagaStore;
import net.thevpc.nuts.reflect.NBeanContainer;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NBooleanRef;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NSagaCallableImpl<T>
implements NSagaCallable<T> {
    private NSagaModel model;
    private final NSagaStore store;
    private NSagaContext fcontext = new NSagaContext(){

        public <V> V getVar(String name) {
            return (V)NSagaCallableImpl.this.model.getContext().get(name);
        }

        @Override
        public NSagaContext setVar(String name, Object value) {
            NSagaCallableImpl.this.model.getContext().put(name, value);
            NSagaCallableImpl.this._store();
            return this;
        }
    };

    public NSagaCallableImpl(NSagaModel model, NSagaStore store) {
        this.model = model;
        this.store = store;
        this._prepareModel();
        this._store(model);
    }

    private void _prepareModel() {
        HashSet<String> visitedIds = new HashSet<String>();
        if (this.model.getContext().getStatus() == null) {
            this.model.getContext().setStatus(NSagaStatus.PENDING);
        }
        this.model.setId(this.validateId(this.model.getId(), visitedIds));
        this.model.setContext(this._prepareNode(this.model.getContext()));
        this.model.setNode(this._prepareNode(this.model.getNode(), visitedIds));
        if (this.model.getContext().getStepsToCompensate() == null) {
            this.model.getContext().setStepsToCompensate(new ArrayDeque<String>());
        }
        for (String s : this.model.getContext().getStepsToCompensate()) {
            if (visitedIds.contains(s)) continue;
            throw new NIllegalArgumentException(NMsg.ofC("invalid id : %s", s));
        }
        for (String s : this.model.getContext().getStackStepId()) {
            if (visitedIds.contains(s)) continue;
            throw new NIllegalArgumentException(NMsg.ofC("invalid id : %s", s));
        }
        if (this.model.getContext().getStackStepIndex() == null) {
            this.model.getContext().setStackStepIndex(new ArrayDeque<Integer>());
        }
        if (this.model.getContext().getStackStepGroup() == null) {
            this.model.getContext().setStackStepGroup(new ArrayDeque<String>());
        }
        if (this.model.getContext().getStackStepId() == null) {
            this.model.getContext().setStackStepId(new ArrayDeque<String>());
        }
        if (this.model.getContext().getStackStepIndex().size() != this.model.getContext().getStackStepGroup().size()) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid stack at : %s", this.model.getId()));
        }
        if (this.model.getContext().getStackStepId().size() != this.model.getContext().getStackStepGroup().size()) {
            throw new NIllegalArgumentException(NMsg.ofC("invalid stack at : %s", this.model.getId()));
        }
        if (!this.model.getContext().getStackStepId().isEmpty() || this.model.getContext().getStatus() == NSagaStatus.PENDING) {
            // empty if block
        }
    }

    private NSagaNodeModel _prepareNode(NSagaNodeModel m, Set<String> visitedIds) {
        if (m == null) {
            return null;
        }
        NAssert.requireNonNull(m.getType(), "type");
        if (NBlankable.isBlank(m.getId())) {
            m.setId(UUID.randomUUID().toString());
        }
        m.setId(this.validateId(m.getId(), visitedIds));
        if (m.getCompensationStrategy() == null) {
            m.setCompensationStrategy(NCompensationStrategy.ABORT);
        }
        if (m.getStatus() == null) {
            m.setStatus(NSagaNodeStatus.PENDING);
        }
        switch (m.getType()) {
            case STEP: {
                NAssert.requireNonNull(m.getStepCall(), "call");
                m.setChildren(null);
                m.setStepCondition(null);
                m.setElseIfBranches(null);
                m.setOtherwiseBranch(null);
                break;
            }
            case IF: {
                m.setStepCall(null);
                break;
            }
            case WHILE: {
                m.setStepCall(null);
                m.setElseIfBranches(null);
                m.setOtherwiseBranch(null);
            }
        }
        return m;
    }

    private NSagaContextModel _prepareNode(NSagaContextModel m) {
        if (m == null) {
            m = new NSagaContextModel();
        }
        return m;
    }

    private String validateId(String id, Set<String> visitedIds) {
        if (NBlankable.isBlank(id)) {
            return UUID.randomUUID().toString();
        }
        if (visitedIds.add(id)) {
            return id;
        }
        throw new NIllegalArgumentException(NMsg.ofC("duplicate id  : %s", id));
    }

    @Override
    public NSagaCallable<T> reset() {
        NSagaContextModel c = this.model.getContext();
        this._resetContext(c);
        this._store();
        return this;
    }

    private void _resetContext(NSagaContextModel c) {
        c.setLastResult(null);
        c.setStartTime(0L);
        c.setEndTime(0L);
        c.getStackStepId().clear();
        c.getStackStepIndex().clear();
        c.getStackStepGroup().clear();
        c.getValues().clear();
        c.getStepsToCompensate().clear();
        c.setStatus(NSagaStatus.PENDING);
    }

    @Override
    public NSagaCallable<T> newInstance() {
        NSagaCallableImpl copy = (NSagaCallableImpl)this.copy();
        copy._resetContext(copy.model.getContext());
        return copy;
    }

    @Override
    public NSagaStatus status() {
        NSagaStatus s = this.model.getContext().getStatus();
        return s == null ? NSagaStatus.PENDING : s;
    }

    @Override
    public T call() {
        while (this.runStep()) {
        }
        return this.getResult();
    }

    @Override
    public NSagaCallable<T> copy() {
        return new NSagaCallableImpl<T>(this.model.clone(), this.store);
    }

    private void _store(NBooleanRef requireStore) {
        if (((Boolean)requireStore.get()).booleanValue()) {
            this._store();
            requireStore.set(false);
        }
    }

    private void _store(NSagaModel model) {
        NRunnable cc = () -> this.store.save(model);
        NBeanContainer.scopedStack().runWith(NBeanContainer.current(), cc);
    }

    private void _store() {
        this._store(this.model);
    }

    private StackItem _pop() {
        NSagaContextModel ctx = this.model.getContext();
        if (!ctx.getStackStepId().isEmpty()) {
            String parentId = ctx.getStackStepId().pop();
            int childIndex = ctx.getStackStepIndex().pop();
            String childGroup = ctx.getStackStepGroup().pop();
            return new StackItem(parentId, childGroup, childIndex);
        }
        return null;
    }

    private void _peekUpdateIndex(int index) {
        NSagaContextModel ctx = this.model.getContext();
        if (!ctx.getStackStepId().isEmpty()) {
            ctx.getStackStepIndex().pop();
            ctx.getStackStepIndex().push(index);
        }
    }

    private StackItem _peek() {
        NSagaContextModel ctx = this.model.getContext();
        if (!ctx.getStackStepId().isEmpty()) {
            String parentId = ctx.getStackStepId().peek();
            int childIndex = ctx.getStackStepIndex().peek();
            String childGroup = ctx.getStackStepGroup().peek();
            return new StackItem(parentId, childGroup, childIndex);
        }
        return null;
    }

    private void _push(StackItem item) {
        NSagaContextModel ctx = this.model.getContext();
        ctx.getStackStepId().push(item.id);
        ctx.getStackStepIndex().push(item.index);
        ctx.getStackStepGroup().push(item.group);
    }

    public boolean runStep_children(String nodeId, List<NSagaNodeModel> list, int idx, String group) {
        if (list != null && idx < list.size()) {
            if (idx + 1 < list.size()) {
                this._push(new StackItem(nodeId, group, idx + 1));
            }
            this._push(new StackItem(list.get(idx).getId(), group, 0));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runStep() {
        NBooleanRef requireStore = NBooleanRef.of(false);
        if (this.model.getContext().getStartTime() == 0L) {
            this.model.getContext().setStartTime(System.currentTimeMillis());
            this._store();
        }
        NSagaContextModel ctx = this.model.getContext();
        NSagaStatus status = ctx.getStatus();
        try {
            switch (status) {
                case ROLLED_BACK: 
                case PARTIAL_ROLLBACK: 
                case FAILED: {
                    boolean bl = this.runCompensationStep(ctx, requireStore);
                    return bl;
                }
                case SUCCESS: {
                    if (this.model.getContext().getEndTime() == 0L) {
                        this.model.getContext().setEndTime(System.currentTimeMillis());
                        requireStore.set();
                        this._store(requireStore);
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            StackItem frame = this._pop();
            if (frame == null) {
                if (this.model.getNode() != null) {
                    frame = new StackItem(this.model.getNode().getId(), null, 0);
                } else {
                    if (this.model.getContext().getEndTime() == 0L) {
                        this.model.getContext().setEndTime(System.currentTimeMillis());
                        requireStore.set();
                        this._store(requireStore);
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            requireStore.set();
            NSagaNodeModel node = this.findById(frame.id);
            if (frame.index == 0) {
                this.preVisit(frame, node, requireStore);
            } else if (!this.runStep_children(node.getId(), node.getChildren(), frame.index, "children")) {
                this.postVisit(frame, node, requireStore);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._store(requireStore);
        }
    }

    private NSagaNodeStatus mergeStatus(Set<NSagaNodeStatus> collect) {
        if (collect.isEmpty()) {
            return NSagaNodeStatus.FINISHED;
        }
        if (collect.size() == 1) {
            return (NSagaNodeStatus)collect.stream().findFirst().get();
        }
        if (collect.contains(NSagaNodeStatus.COMPENSATION_FAILED)) {
            return NSagaNodeStatus.COMPENSATION_FAILED;
        }
        if (collect.contains(NSagaNodeStatus.COMPENSATION_IGNORED)) {
            return NSagaNodeStatus.COMPENSATION_IGNORED;
        }
        if (collect.contains(NSagaNodeStatus.FAILED)) {
            return NSagaNodeStatus.FAILED;
        }
        if (collect.contains(NSagaNodeStatus.COMPENSATING)) {
            return NSagaNodeStatus.COMPENSATING;
        }
        if (collect.contains(NSagaNodeStatus.COMPENSATED)) {
            return NSagaNodeStatus.COMPENSATED;
        }
        if (collect.contains(NSagaNodeStatus.RUNNING)) {
            return NSagaNodeStatus.RUNNING;
        }
        if (collect.contains(NSagaNodeStatus.IGNORED)) {
            return NSagaNodeStatus.IGNORED;
        }
        if (collect.contains(NSagaNodeStatus.FINISHED)) {
            return NSagaNodeStatus.FINISHED;
        }
        if (collect.contains(NSagaNodeStatus.PENDING)) {
            return NSagaNodeStatus.PENDING;
        }
        return NSagaNodeStatus.PENDING;
    }

    private boolean postVisit(StackItem stackItem, NSagaNodeModel current, NBooleanRef requireStore) {
        switch (current.getType()) {
            case WHILE: 
            case SUITE: {
                current.setStatus(this.mergeStatus(current.getChildren().stream().map(x -> x.getStatus()).collect(Collectors.toSet())));
                this._store(requireStore);
                return true;
            }
            case IF: {
                TreeSet all = new TreeSet();
                if (current.getChildren() != null) {
                    all.addAll(current.getChildren().stream().map(x -> x.getStatus()).collect(Collectors.toSet()));
                }
                if (current.getElseIfBranches() != null) {
                    all.addAll(current.getElseIfBranches().stream().map(x -> x.getStatus()).collect(Collectors.toSet()));
                }
                if (current.getOtherwiseBranch() != null) {
                    all.addAll(current.getOtherwiseBranch().stream().map(x -> x.getStatus()).collect(Collectors.toSet()));
                }
                all.remove(NSagaNodeStatus.PENDING);
                current.setStatus(this.mergeStatus(current.getChildren().stream().map(x -> x.getStatus()).collect(Collectors.toSet())));
                this._store(requireStore);
                return true;
            }
        }
        return false;
    }

    private boolean preVisit(StackItem stackItem, NSagaNodeModel current, NBooleanRef requireStore) {
        NSagaContextModel ctx = this.model.getContext();
        switch (current.getType()) {
            case SUITE: {
                if (!this.runStep_children(current.getId(), current.getChildren(), stackItem.index, "children")) {
                    this.postVisit(stackItem, current, requireStore);
                }
                return true;
            }
            case IF: {
                NSagaCondition mainCond = current.getStepCondition();
                try {
                    if (mainCond != null && mainCond.test(this.fcontext)) {
                        if (!this.runStep_children(stackItem.id, current.getChildren(), stackItem.index, "children")) {
                            this.postVisit(stackItem, current, requireStore);
                        }
                        return true;
                    }
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("Error evaluating IF condition for node " + stackItem.id, ex);
                }
                if (current.getElseIfBranches() != null) {
                    for (NSagaNodeModel elseIfWrapper : current.getElseIfBranches()) {
                        NSagaCondition elseCond = elseIfWrapper.getStepCondition();
                        try {
                            if (elseCond == null || !elseCond.test(this.fcontext)) continue;
                            if (!this.runStep_children(stackItem.id, elseIfWrapper.getChildren(), stackItem.index, "elseIf")) {
                                this.postVisit(stackItem, current, requireStore);
                            }
                            return true;
                        }
                        catch (RuntimeException ex) {
                            throw new RuntimeException("Error evaluating ELSE-IF condition for node " + elseIfWrapper.getId(), ex);
                        }
                    }
                }
                if (!this.runStep_children(stackItem.id, current.getOtherwiseBranch(), stackItem.index, "else")) {
                    this.postVisit(stackItem, current, requireStore);
                }
                return true;
            }
            case WHILE: {
                NSagaCondition mainCond = current.getStepCondition();
                try {
                    if (mainCond != null && mainCond.test(this.fcontext)) {
                        this.runStep_children(stackItem.id, current.getChildren(), stackItem.index, "children");
                        this._push(new StackItem(stackItem.id, null, 0));
                        return true;
                    }
                    this.postVisit(stackItem, current, requireStore);
                    break;
                }
                catch (RuntimeException ex) {
                    throw new RuntimeException("Error evaluating IF condition for node " + stackItem.id, ex);
                }
            }
        }
        try {
            current.setStatus(NSagaNodeStatus.RUNNING);
            this._store(requireStore);
            Object result = current.getStepCall().call(this.fcontext);
            this.model.getContext().setLastResult(result);
            if (current.getType() != NSagaNodeType.UNDO) {
                ctx.getStepsToCompensate().add(current.getId());
            }
            current.setStatus(NSagaNodeStatus.FINISHED);
            this._store(requireStore);
            this.postVisit(stackItem, current, requireStore);
        }
        catch (Exception ex) {
            if (ctx.getFirstFailStepThrowable() == null) {
                ctx.setFirstFailStepThrowable(ex);
                ctx.setFirstFailStepId(current.getId());
                ctx.setFirstFailStepName(current.getName());
            }
            current.setStatus(NSagaNodeStatus.FAILED);
            ctx.setStatus(NSagaStatus.FAILED);
            this._store(requireStore);
            return this.runCompensationStep(ctx, requireStore);
        }
        return true;
    }

    private boolean runCompensationStep(NSagaContextModel context, NBooleanRef requireStore) {
        if (context.getStepsToCompensate().isEmpty()) {
            context.setStatus(NSagaStatus.ROLLED_BACK);
            requireStore.set();
            if (this.model.getContext().getEndTime() == 0L) {
                this.model.getContext().setEndTime(System.currentTimeMillis());
                requireStore.set();
            }
            return false;
        }
        String last = null;
        NSagaNodeModel m0 = null;
        try {
            last = context.getStepsToCompensate().removeLast();
            if (last != null) {
                requireStore.set();
                m0 = this.findById(last);
            }
            if (m0 == null) {
                return true;
            }
            switch (m0.getStatus()) {
                case COMPENSATION_FAILED: 
                case COMPENSATION_IGNORED: {
                    break;
                }
                default: {
                    m0.setStatus(NSagaNodeStatus.COMPENSATING);
                    this._store();
                    m0.getStepCall().undo(this.fcontext);
                    m0.setStatus(NSagaNodeStatus.COMPENSATED);
                    this._store();
                }
            }
            if (context.getStepsToCompensate().isEmpty()) {
                context.setStatus(NSagaStatus.ROLLED_BACK);
                requireStore.set();
                if (this.model.getContext().getEndTime() == 0L) {
                    this.model.getContext().setEndTime(System.currentTimeMillis());
                    requireStore.set();
                }
                return false;
            }
            if (context.getStatus() != NSagaStatus.PARTIAL_ROLLBACK) {
                context.setStatus(NSagaStatus.ROLLED_BACK);
                requireStore.set();
            }
            return true;
        }
        catch (Exception e) {
            context.setFirstFailStepThrowable(e);
            boolean doAbort = false;
            if (m0 != null) {
                m0.setStatus(NSagaNodeStatus.COMPENSATION_FAILED);
                switch (m0.getCompensationStrategy()) {
                    case ABORT: {
                        doAbort = true;
                        for (String s : context.getStepsToCompensate()) {
                            NSagaNodeModel n = this.findById(s);
                            if (n == null) continue;
                            n.setStatus(NSagaNodeStatus.COMPENSATION_IGNORED);
                        }
                        break;
                    }
                }
                requireStore.set();
            }
            if (doAbort) {
                context.setStatus(NSagaStatus.FAILED);
                requireStore.set();
                throw NExceptions.ofUncheckedException(e);
            }
            if (context.getStepsToCompensate().isEmpty()) {
                context.setStatus(NSagaStatus.FAILED);
            } else {
                context.setStatus(NSagaStatus.PARTIAL_ROLLBACK);
            }
            requireStore.set();
            return true;
        }
    }

    public NSagaNodeModel findById(String id) {
        return this.findByIdRecursive(this.model.getNode(), id);
    }

    private NSagaNodeModel findByIdRecursive(NSagaNodeModel node, String id) {
        NSagaNodeModel found;
        if (id.equals(node.getId())) {
            return node;
        }
        if (node.getChildren() != null) {
            for (NSagaNodeModel child : node.getChildren()) {
                found = this.findByIdRecursive(child, id);
                if (found == null) continue;
                return found;
            }
        }
        if (node.getOtherwiseBranch() != null) {
            for (NSagaNodeModel child : node.getOtherwiseBranch()) {
                found = this.findByIdRecursive(child, id);
                if (found == null) continue;
                return found;
            }
        }
        if (node.getElseIfBranches() != null) {
            for (NSagaNodeModel child : node.getElseIfBranches()) {
                found = this.findByIdRecursive(child, id);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    @Override
    public T callOrElse(NCallable<T> other) {
        try {
            return this.call();
        }
        catch (Exception ex) {
            return other.call();
        }
    }

    @Override
    public <V> V getVar(String key) {
        return (V)this.model.getContext().getValues().get(key);
    }

    @Override
    public NSagaCallable<T> setVar(String key, Object value) {
        this.model.getContext().getValues().put(key, value);
        this._store();
        return this;
    }

    @Override
    public T getResult() {
        return (T)this.model.getContext().getLastResult();
    }

    private static class StackItem {
        String id;
        String group;
        int index;

        public StackItem(String id, String group, int index) {
            this.id = id;
            this.group = group;
            this.index = index;
        }
    }
}

