/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.thevpc.nuts.concurrent.NCompensationStrategy;
import net.thevpc.nuts.concurrent.NSagaCallable;
import net.thevpc.nuts.concurrent.NSagaCallableBuilder;
import net.thevpc.nuts.concurrent.NSagaCondition;
import net.thevpc.nuts.concurrent.NSagaModel;
import net.thevpc.nuts.concurrent.NSagaNodeModel;
import net.thevpc.nuts.concurrent.NSagaNodeType;
import net.thevpc.nuts.concurrent.NSagaStep;
import net.thevpc.nuts.concurrent.NSagaStore;
import net.thevpc.nuts.runtime.standalone.concurrent.NSagaCallableImpl;

public class NSagaCallableBuilderImpl
implements NSagaCallableBuilder {
    private final AtomicInteger idCounter = new AtomicInteger(1);
    private final NSagaStore store;
    private final List<NSagaNodeModel> roots = new ArrayList<NSagaNodeModel>();

    public NSagaCallableBuilderImpl(NSagaStore store) {
        this.store = store;
    }

    @Override
    public NSagaCallableBuilder.Suite<NSagaCallableBuilder> start() {
        return new SuiteImpl<NSagaCallableBuilder>(this, this.roots, this);
    }

    public NSagaCallable build() {
        NSagaModel saga = new NSagaModel();
        if (!this.roots.isEmpty()) {
            if (this.roots.size() == 1) {
                saga.setNode(this.roots.get(0));
            } else {
                NSagaNodeModel m = new NSagaNodeModel();
                m.setType(NSagaNodeType.SUITE);
                m.setId(UUID.randomUUID().toString());
                m.setCompensationStrategy(NCompensationStrategy.ABORT);
                m.setName("<root>");
                m.setChildren(this.roots.stream().map(x -> x.copy()).collect(Collectors.toList()));
                saga.setNode(m);
            }
        }
        return new NSagaCallableImpl(saga.clone(), this.store);
    }

    private String nextId() {
        return "node-" + this.idCounter.getAndIncrement();
    }

    private class SuiteImpl<P>
    implements NSagaCallableBuilder.Suite<P> {
        private final P parent;
        private final List<NSagaNodeModel> currentNodes;
        private final NSagaCallableBuilder builder;

        SuiteImpl(P parent, List<NSagaNodeModel> currentNodes, NSagaCallableBuilder builder) {
            this.parent = parent;
            this.currentNodes = currentNodes;
            this.builder = builder;
        }

        private String nextId() {
            return "node-" + NSagaCallableBuilderImpl.this.idCounter.getAndIncrement();
        }

        @Override
        public NSagaCallableBuilder.Suite<P> then(String name, NSagaStep step) {
            NSagaNodeModel node = new NSagaNodeModel().setId(this.nextId()).setName(name).setStepCall(step).setType(NSagaNodeType.STEP);
            this.currentNodes.add(node);
            return this;
        }

        @Override
        public NSagaCallableBuilder.If<NSagaCallableBuilder.Suite<P>> thenIf(String name, NSagaCondition condition) {
            NSagaNodeModel node = new NSagaNodeModel().setId(this.nextId()).setName(name).setStepCondition(condition).setType(NSagaNodeType.IF);
            this.currentNodes.add(node);
            return new IfImpl<NSagaCallableBuilder.Suite<P>>(this, node);
        }

        @Override
        public NSagaCallableBuilder.While<NSagaCallableBuilder.Suite<P>> thenWhile(String name, NSagaCondition condition) {
            NSagaNodeModel node = new NSagaNodeModel().setId(this.nextId()).setName(name).setStepCondition(condition).setType(NSagaNodeType.WHILE);
            this.currentNodes.add(node);
            return new WhileImpl<NSagaCallableBuilder.Suite<P>>(this, node.getChildren(), node);
        }

        @Override
        public P end() {
            return this.parent;
        }
    }

    private class WhileImpl<P>
    implements NSagaCallableBuilder.While<P> {
        private final P parent;
        private final List<NSagaNodeModel> currentNodes;
        private final NSagaNodeModel whileNode;

        WhileImpl(P parent, List<NSagaNodeModel> currentNodes, NSagaNodeModel whileNode) {
            this.parent = parent;
            this.currentNodes = currentNodes;
            this.whileNode = whileNode;
        }

        private String nextId() {
            return "node-" + NSagaCallableBuilderImpl.this.idCounter.getAndIncrement();
        }

        @Override
        public NSagaCallableBuilder.While<P> then(String name, NSagaStep step) {
            NSagaNodeModel node = new NSagaNodeModel().setId(this.nextId()).setName(name).setStepCall(step).setType(NSagaNodeType.STEP);
            this.currentNodes.add(node);
            return this;
        }

        @Override
        public NSagaCallableBuilder.If<NSagaCallableBuilder.While<P>> thenIf(String name, NSagaCondition condition) {
            NSagaNodeModel node = new NSagaNodeModel().setId(this.nextId()).setName(name).setStepCondition(condition).setType(NSagaNodeType.IF);
            this.currentNodes.add(node);
            return new IfImpl<NSagaCallableBuilder.While<P>>(this, node);
        }

        @Override
        public NSagaCallableBuilder.While<NSagaCallableBuilder.While<P>> thenWhile(String name, NSagaCondition condition) {
            NSagaNodeModel node = new NSagaNodeModel().setId(this.nextId()).setName(name).setStepCondition(condition).setType(NSagaNodeType.WHILE);
            this.currentNodes.add(node);
            return new WhileImpl<NSagaCallableBuilder.While<P>>(this, node.getChildren(), node);
        }

        @Override
        public P end() {
            return this.parent;
        }
    }

    private class IfImpl<P>
    implements NSagaCallableBuilder.If<P> {
        private final P parent;
        private final NSagaNodeModel ifNode;
        private List<NSagaNodeModel> currentNodes;

        public IfImpl(P parent, NSagaNodeModel ifNode) {
            this.parent = parent;
            this.ifNode = ifNode;
            this.currentNodes = ifNode.getChildren();
        }

        @Override
        public NSagaCallableBuilder.If<P> then(String name, NSagaStep step) {
            NSagaNodeModel node = new NSagaNodeModel().setId(NSagaCallableBuilderImpl.this.nextId()).setName(name).setStepCall(step).setType(NSagaNodeType.STEP);
            this.currentNodes.add(node);
            return this;
        }

        @Override
        public NSagaCallableBuilder.If<P> elseIf(String name, NSagaCondition condition) {
            NSagaNodeModel node = new NSagaNodeModel().setId(NSagaCallableBuilderImpl.this.nextId()).setName(name).setStepCondition(condition).setType(NSagaNodeType.SUITE);
            this.ifNode.getElseIfBranches().add(node);
            this.currentNodes = node.getChildren();
            return this;
        }

        @Override
        public NSagaCallableBuilder.If<P> otherwise() {
            NSagaNodeModel node = new NSagaNodeModel().setId(NSagaCallableBuilderImpl.this.nextId()).setName("otherwise").setType(NSagaNodeType.SUITE);
            this.ifNode.getOtherwiseBranch().add(node);
            this.currentNodes = node.getChildren();
            return this;
        }

        @Override
        public P end() {
            return this.parent;
        }

        @Override
        public NSagaCallableBuilder.If<NSagaCallableBuilder.If<P>> thenIf(String name, NSagaCondition condition) {
            NSagaNodeModel node = new NSagaNodeModel().setId(NSagaCallableBuilderImpl.this.nextId()).setName(name).setStepCondition(condition).setType(NSagaNodeType.IF);
            this.currentNodes.add(node);
            return new IfImpl<NSagaCallableBuilder.If<P>>(this, node);
        }

        @Override
        public NSagaCallableBuilder.While<NSagaCallableBuilder.If<P>> thenWhile(String name, NSagaCondition condition) {
            NSagaNodeModel node = new NSagaNodeModel().setId(NSagaCallableBuilderImpl.this.nextId()).setName(name).setStepCondition(condition).setType(NSagaNodeType.WHILE);
            this.currentNodes.add(node);
            return new WhileImpl<NSagaCallableBuilder.If<P>>(this, node.getChildren(), node);
        }
    }
}

