/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.IntFunction;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NConcurrent;
import net.thevpc.nuts.concurrent.NRetryCall;
import net.thevpc.nuts.concurrent.NRetryCallModel;
import net.thevpc.nuts.concurrent.NRetryCallStore;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NCancelException;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NIllegalStateException;

public class NRetryCallImpl<T>
implements NRetryCall<T> {
    private NRetryCallStore store;
    private NRetryCallModel model;

    public NRetryCallImpl(String id, NCallable<T> callable, NRetryCallStore store) {
        this.store = store;
        this.model = new NRetryCallModel(id);
        this.model.setCaller(callable);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        NRetryCallImpl nRetryCallImpl = this;
        synchronized (nRetryCallImpl) {
            String oldId = this.model.getId();
            NCallable<?> oldCaller = this.model.getCaller();
            NRetryCallModel m = this.store.load(oldId);
            if (m == null) {
                NAssert.requireNonNull(oldCaller, "caller");
                m = new NRetryCallModel(oldId);
                m.setCaller(oldCaller);
                this.store.save(m);
            } else if (oldCaller != null) {
                m.setCaller(oldCaller);
                this.store.save(m);
            }
            this.model = m;
        }
    }

    @Override
    public NRetryCall<T> setMaxRetries(int maxRetries) {
        maxRetries = Math.max(1, maxRetries);
        int old = this.model.getMaxRetries();
        if (old != maxRetries) {
            this.model.setMaxRetries(maxRetries);
            this.store.save(this.model);
        }
        return this;
    }

    @Override
    public NRetryCall<T> setMultipliedRetryPeriod(NDuration basePeriod, double multiplier) {
        return this.setRetryPeriod(this._retryMultipliedPeriod(basePeriod, multiplier));
    }

    @Override
    public NRetryCall<T> setExponentialRetryPeriod(NDuration basePeriod, double multiplier) {
        return this.setRetryPeriod(this._retryExponentialPeriod(basePeriod, multiplier));
    }

    @Override
    public NRetryCall<T> setRetryPeriod(NDuration period) {
        return this.setRetryPeriod(this._retryFixedPeriods(period));
    }

    @Override
    public NRetryCall<T> setRetryPeriods(NDuration ... periods) {
        return this.setRetryPeriod(this._retryFixedPeriods(periods));
    }

    @Override
    public NRetryCall<T> setRetryPeriod(IntFunction<NDuration> retryPeriod) {
        this.model.setRetryPeriod(retryPeriod);
        this.store.save(this.model);
        return this;
    }

    @Override
    public NRetryCall<T> setRecover(NCallable<T> recover) {
        this.model.setRecover(recover);
        this.store.save(this.model);
        return this;
    }

    @Override
    public NRetryCall<T> setHandler(NRetryCall.Handler<T> handler) {
        this.model.setHandler(handler);
        this.store.save(this.model);
        return this;
    }

    @Override
    public T callOrElse(NCallable<T> recover) {
        try {
            return this.call();
        }
        catch (Exception ex) {
            if (recover != null) {
                return recover.call();
            }
            return null;
        }
    }

    @Override
    public T call() {
        NRetryCallImpl nRetryCallImpl = this;
        synchronized (nRetryCallImpl) {
            String id = this.model.getId();
            this.model = this.store.load(id);
            if (this.model.getStatus() == NRetryCall.Status.RUNNING || this.model.getStatus() == NRetryCall.Status.HANDLING) {
                throw new NIllegalStateException(NMsg.ofC("Call [%s] is already running or handling.", id));
            }
            if (this.model.getStatus() == NRetryCall.Status.HANDLED || this.model.getStatus() == NRetryCall.Status.SUCCEEDED) {
                return (T)this.model.getResult();
            }
            if (this.model.getStatus() == NRetryCall.Status.CANCELLED) {
                throw new NCancelException(NMsg.ofC("Call %s cancelled", id));
            }
            int maxRetries = Math.max(1, this.model.getMaxRetries());
            int attempts = this.model.getFailedAttempts();
            while (attempts < maxRetries) {
                try {
                    this.model.setStatus(NRetryCall.Status.RUNNING);
                    this.store.save(this.model);
                    Object result = this.model.getCaller().call();
                    this.model.setResult(result);
                    this.model.setStatus(NRetryCall.Status.SUCCEEDED);
                    this.store.save(this.model);
                    return (T)this.handleResultAndFinish(result);
                }
                catch (Exception ex) {
                    this.model.setFailedAttempts(++attempts);
                    this.model.setThrowable(ex);
                    this.model.setStatus(NRetryCall.Status.FAILED_ATTEMPT);
                    this.store.save(this.model);
                    if (attempts >= maxRetries) {
                        this.model.setStatus(NRetryCall.Status.FAILED);
                        this.store.save(this.model);
                        NCallable<?> recover = this.model.getRecover();
                        if (recover != null) {
                            try {
                                Object recovered = recover.call();
                                this.model.setResult(recovered);
                                this.model.setStatus(NRetryCall.Status.SUCCEEDED);
                                this.store.save(this.model);
                                return (T)this.handleResultAndFinish(recovered);
                            }
                            catch (Exception rex) {
                                this.model.setThrowable(rex);
                                this.store.save(this.model);
                                throw rex;
                            }
                        }
                        throw ex;
                    }
                    NDuration wait = this.model.getRetryPeriod() != null ? this.model.getRetryPeriod().apply(attempts) : NDuration.ZERO;
                    if (wait.isZero()) continue;
                    this.model.setStatus(NRetryCall.Status.RETRYING);
                    this.store.save(this.model);
                    try {
                        Thread.sleep(wait.toMillis());
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw NExceptions.ofUncheckedException(ie);
                    }
                }
            }
            throw new NIllegalStateException(NMsg.ofC("Call [%s] ended in unexpected state: %s", new Object[]{id, this.model.getStatus()}));
        }
    }

    private T handleResultAndFinish(T result) {
        NRetryCall.Handler<?> handler = this.model.getHandler();
        if (handler != null) {
            try {
                this.model.setStatus(NRetryCall.Status.HANDLING);
                this.store.save(this.model);
                handler.handle(this.newCallResult());
                this.model.setStatus(NRetryCall.Status.HANDLED);
                this.store.save(this.model);
            }
            catch (Exception hx) {
                this.model.setThrowable(hx);
                this.model.setStatus(NRetryCall.Status.HANDLER_FAILED);
                this.store.save(this.model);
                throw hx;
            }
        } else {
            this.model.setStatus(NRetryCall.Status.HANDLED);
            this.store.save(this.model);
        }
        return result;
    }

    private NRetryCall.Result<T> newCallResult() {
        final Object result = this.model.getResult();
        final NRetryCall.Status status = this.model.getStatus();
        return new NRetryCall.Result<T>(){

            @Override
            public String id() {
                return NRetryCallImpl.this.model.getId();
            }

            @Override
            public NRetryCall<T> value() {
                return NRetryCallImpl.this;
            }

            @Override
            public boolean isValid() {
                return status == NRetryCall.Status.SUCCEEDED;
            }

            @Override
            public boolean isError() {
                return status == NRetryCall.Status.FAILED;
            }

            @Override
            public T result() {
                switch (status) {
                    case SUCCEEDED: {
                        return result;
                    }
                    case FAILED: {
                        throw NExceptions.ofUncheckedException((Throwable)NRetryCallImpl.this.model.getThrowable());
                    }
                    case RUNNING: {
                        throw new NIllegalStateException(NMsg.ofC("still running"));
                    }
                    case QUEUED: {
                        throw new NIllegalStateException(NMsg.ofC("still queued"));
                    }
                    case CREATED: {
                        throw new NIllegalStateException(NMsg.ofC("still created"));
                    }
                    case CANCELLED: {
                        throw new NCancelException(NMsg.ofC("cancelled"));
                    }
                    case FAILED_ATTEMPT: {
                        throw new NIllegalStateException(NMsg.ofC("still failed attempt"));
                    }
                    case RETRYING: {
                        throw new NIllegalStateException(NMsg.ofC("still retrying"));
                    }
                }
                return result;
            }
        };
    }

    @Override
    public void callAsync() {
    }

    @Override
    public Future<NRetryCall.Result<T>> callFuture() {
        ExecutorService executor = NConcurrent.of().executorService();
        return executor.submit(() -> {
            T result = this.call();
            return this.newCallResult();
        });
    }

    private IntFunction<NDuration> _retryFixedPeriods(NDuration ... periods) {
        final ArrayList<NDuration> all = new ArrayList<NDuration>();
        if (periods == null) {
            all.add(NDuration.ofMillis(0L));
        } else {
            for (NDuration period : periods) {
                if (period != null) {
                    all.add(period);
                    continue;
                }
                all.add(NDuration.ofMillis(0L));
            }
        }
        return new IntFunction<NDuration>(){

            @Override
            public NDuration apply(int i) {
                if (i < all.size()) {
                    return (NDuration)all.get(i);
                }
                return (NDuration)all.get(all.size() - 1);
            }
        };
    }

    private IntFunction<NDuration> _retryMultipliedPeriod(final NDuration base, final double multiplier) {
        if (base == null || base.isZero() || multiplier <= 0.0) {
            return this._retryFixedPeriods(NDuration.ofMillis(0L));
        }
        return new IntFunction<NDuration>(){

            @Override
            public NDuration apply(int iteration) {
                return base.mul(multiplier * (double)iteration);
            }
        };
    }

    private IntFunction<NDuration> _retryExponentialPeriod(final NDuration base, final double multiplier) {
        if (base == null || base.isZero() || multiplier <= 0.0) {
            return this._retryFixedPeriods(NDuration.ofMillis(0L));
        }
        return new IntFunction<NDuration>(){

            @Override
            public NDuration apply(int iteration) {
                return base.mul(Math.pow(multiplier, iteration));
            }
        };
    }
}

