/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.time.Instant;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NRateLimitRule;
import net.thevpc.nuts.concurrent.NRateLimitRuleModel;
import net.thevpc.nuts.concurrent.NRateLimitValue;
import net.thevpc.nuts.concurrent.NRateLimitValueModel;
import net.thevpc.nuts.concurrent.NRateLimitValueResult;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitValueFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitValueResultImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;

class NRateLimitValueImpl
implements NRateLimitValue {
    private NRateLimitValueFactoryImpl factory;
    private String id;

    public NRateLimitValueImpl(NRateLimitValueModel data, NRateLimitValueFactoryImpl factory) {
        this.id = data.getId();
        this.factory = factory;
    }

    public NRateLimitValueModel model() {
        return this.factory.load(this.id);
    }

    @Override
    public synchronized NRateLimitValueResult take() {
        return this.take(1);
    }

    @Override
    public synchronized NRateLimitValueResult take(int count) {
        Instant lastAccess = Instant.now();
        NRateLimitValueModel model = this.model();
        NRateLimitRuleModel[] ruleModels = model.getRules();
        NRateLimitRule[] rules = new NRateLimitRule[ruleModels.length];
        for (int i = 0; i < ruleModels.length; ++i) {
            NRateLimitRule rule;
            NRateLimitRuleModel ruleModel = ruleModels[i];
            rules[i] = rule = this.factory.createRule(ruleModel);
            if (rule.tryConsume(count)) continue;
            return new NRateLimitValueResultImpl(false, null, NMsg.ofC("rate limit exceeded (%s) for %s", ruleModel.getId(), this.id));
        }
        this.factory.save(new NRateLimitValueModel(this.id, lastAccess == null ? 0L : lastAccess.getEpochSecond(), (NRateLimitRuleModel[])Arrays.stream(rules).map(NRateLimitRule::toModel).toArray(NRateLimitRuleModel[]::new)));
        return new NRateLimitValueResultImpl(true, null, null);
    }

    @Override
    public NRateLimitValueResult takeAndRun(Runnable runnable) {
        return this.takeAndRun(1, runnable);
    }

    @Override
    public NRateLimitValueResult takeAndRun(int count, Runnable runnable) {
        return this.take(count).onSuccess(runnable);
    }

    @Override
    public <T> NRateLimitValueResult takeAndCall(int count, NCallable<T> callable) {
        return this.take(count).onSuccessCall(callable);
    }

    @Override
    public <T> NRateLimitValueResult takeAndCall(NCallable<T> callable) {
        return this.take().onSuccessCall(callable);
    }

    @Override
    public NRateLimitValueResult claim(int count) {
        return this.claim(count, null);
    }

    @Override
    public NRateLimitValueResult claim(int count, NDuration timeout) {
        long start = System.currentTimeMillis();
        long maxWaitTimeMillis = timeout != null ? timeout.toMillis() : -1L;
        long deadline = timeout != null ? start + timeout.toMillis() : Long.MAX_VALUE;
        while (true) {
            long now;
            NRateLimitValueResult take = null;
            NRateLimitValueModel model = this.model();
            Instant lastAccess = Instant.now();
            long shouldWaitForMs = 0L;
            NRateLimitRuleModel[] ruleModels = model.getRules();
            NRateLimitRule[] rules = new NRateLimitRule[ruleModels.length];
            NRateLimitRuleModel faultyRuleModel = null;
            for (int i = 0; i < ruleModels.length; ++i) {
                NRateLimitRule rule;
                NRateLimitRuleModel ruleModel = ruleModels[i];
                rules[i] = rule = this.factory.createRule(ruleModel);
                if (rule.tryConsume(count)) continue;
                if (take == null) {
                    faultyRuleModel = ruleModel;
                    take = new NRateLimitValueResultImpl(false, null, NMsg.ofC("rate limit exceeded (%s) for %s", ruleModel.getId(), this.id));
                }
                shouldWaitForMs = Math.max(shouldWaitForMs, rule.nextAvailableMillis(count));
            }
            this.factory.save(new NRateLimitValueModel(this.id, lastAccess == null ? 0L : lastAccess.getEpochSecond(), (NRateLimitRuleModel[])Arrays.stream(rules).map(NRateLimitRule::toModel).toArray(NRateLimitRuleModel[]::new)));
            if (take == null) {
                take = new NRateLimitValueResultImpl(true, null, null);
            }
            if (take.success()) {
                return take;
            }
            if (shouldWaitForMs <= 0L) {
                shouldWaitForMs = 10L;
            }
            if (maxWaitTimeMillis > 0L && (now = System.currentTimeMillis()) >= deadline) {
                if (faultyRuleModel != null) {
                    return new NRateLimitValueResultImpl(false, null, NMsg.ofC("rate limit exceeded (%s) for %s after %s ms", faultyRuleModel.getId(), this.id, maxWaitTimeMillis));
                }
                return new NRateLimitValueResultImpl(false, null, NMsg.ofC("rate limit exceeded for %s after %s ms", this.id, maxWaitTimeMillis));
            }
            try {
                Thread.sleep(shouldWaitForMs);
            }
            catch (InterruptedException e) {
                if (faultyRuleModel != null) {
                    return new NRateLimitValueResultImpl(false, null, NMsg.ofC("rate limit exceeded (%s) for %s after %s ms", faultyRuleModel.getId(), this.id, maxWaitTimeMillis));
                }
                return new NRateLimitValueResultImpl(false, null, NMsg.ofC("rate limit exceeded for %s after %s ms", this.id, maxWaitTimeMillis));
            }
        }
    }

    @Override
    public NRateLimitValueResult claimAndRun(Runnable runnable) {
        return this.claim(1).onSuccess(runnable);
    }

    @Override
    public <T> NRateLimitValueResult claimAndCall(int count, NCallable<T> callable) {
        return this.claim(count).onSuccessCall(callable);
    }

    @Override
    public <T> NRateLimitValueResult claimAndCall(NDuration timeout, NCallable<T> callable) {
        return this.claim(1, timeout).onSuccessCall(callable);
    }

    @Override
    public <T> NRateLimitValueResult claimAndCall(int count, NDuration timeout, NCallable<T> callable) {
        return this.claim(count, timeout).onSuccessCall(callable);
    }

    @Override
    public NRateLimitValueResult claimAndRun(int count, Runnable runnable) {
        return this.claim(count).onSuccess(runnable);
    }

    @Override
    public NRateLimitValueResult claimAndRun(NDuration timeout, Runnable runnable) {
        return this.claim(1, timeout).onSuccess(runnable);
    }

    @Override
    public NRateLimitValueResult claimAndRun(int count, NDuration timeout, Runnable runnable) {
        return this.claim(count, timeout).onSuccess(runnable);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NRateLimitValueImpl that = (NRateLimitValueImpl)o;
        return Objects.equals(this.factory, that.factory) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.factory, this.id);
    }

    @Override
    public NElement describe() {
        return this.model().describe();
    }
}

