/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.thevpc.nuts.concurrent.NRateLimitRuleBuilder;
import net.thevpc.nuts.concurrent.NRateLimitRuleModel;
import net.thevpc.nuts.concurrent.NRateLimitValue;
import net.thevpc.nuts.concurrent.NRateLimitValueBuilder;
import net.thevpc.nuts.concurrent.NRateLimitValueModel;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitRuleBuilderImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitValueFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitValueImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollectionDiff;
import net.thevpc.nuts.util.NCollectionDiffChange;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NRateLimitValueBuilderImpl
implements NRateLimitValueBuilder {
    String id;
    NRateLimitRuleBuilderImpl lastRule;
    List<NRateLimitRuleBuilderImpl> rules = new ArrayList<NRateLimitRuleBuilderImpl>();
    private NRateLimitValueFactoryImpl factory;

    public NRateLimitValueBuilderImpl(String id, NRateLimitValueFactoryImpl factory) {
        this.id = id;
        this.factory = factory;
    }

    @Override
    public NRateLimitValueBuilder id(String id) {
        this.id = id;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NRateLimitValue build() {
        void var6_12;
        NRateLimitRuleBuilderImpl[] currRules = this.rules();
        if (currRules.length == 0) {
            throw new NIllegalArgumentException(NMsg.ofC("missing rules"));
        }
        HashSet<String> visited = new HashSet<String>();
        for (NRateLimitRuleBuilderImpl nRateLimitRuleBuilderImpl : currRules) {
            String cid = nRateLimitRuleBuilderImpl.getId();
            if (NBlankable.isBlank(cid) || visited.add(cid)) continue;
            throw new NIllegalArgumentException(NMsg.ofC("duplicate rule id %s for %s", cid, this.id));
        }
        visited = new HashSet();
        int index = 1;
        NRateLimitRuleBuilderImpl[] nRateLimitRuleBuilderImplArray = currRules;
        int n = nRateLimitRuleBuilderImplArray.length;
        boolean bl = false;
        while (var6_12 < n) {
            block15: {
                NRateLimitRuleBuilderImpl c = nRateLimitRuleBuilderImplArray[var6_12];
                String cid = c.getId();
                if (NBlankable.isBlank(cid)) {
                    while (true) {
                        String cid2;
                        if (visited.add(cid2 = "rule-" + index)) {
                            c.setId(cid2);
                            break block15;
                        }
                        ++index;
                    }
                }
                if (!visited.add(cid)) {
                    throw new NIllegalArgumentException(NMsg.ofC("duplicate rule id %s for %s", cid, this.id));
                }
            }
            ++var6_12;
        }
        NRateLimitValueModel newModel = new NRateLimitValueModel(this.id, 0L, (NRateLimitRuleModel[])Arrays.stream(currRules).map(x -> new NRateLimitRuleModel(x.getId(), x.getStrategy(), x.getMax(), x.getDuration() == null ? 0L : x.getDuration().toMillis(), 0.0, x.getStartDate() == null ? 0L : x.getStartDate().toEpochMilli(), new byte[0])).toArray(NRateLimitRuleModel[]::new));
        NRateLimitValueModel old = this.factory.load(newModel.getId());
        if (old == null) {
            this.factory.save(newModel);
            return new NRateLimitValueImpl(newModel, this.factory);
        }
        ArrayList<NRateLimitRuleModel> okkay = new ArrayList<NRateLimitRuleModel>();
        for (NCollectionDiffChange<NRateLimitRuleModel> nCollectionDiffChange : NCollectionDiff.diffList(Arrays.asList(old.getRules()), Arrays.asList(newModel.getRules()), m -> m.getId())) {
            switch (nCollectionDiffChange.getMode()) {
                case ADDED: {
                    okkay.add(nCollectionDiffChange.getNewValue());
                    break;
                }
                case REMOVED: {
                    break;
                }
                case CHANGED: {
                    okkay.add(new NRateLimitRuleModel(nCollectionDiffChange.getNewValue().getId(), nCollectionDiffChange.getNewValue().getStrategy(), nCollectionDiffChange.getNewValue().getCapacity(), nCollectionDiffChange.getNewValue().getDuration(), Math.min(nCollectionDiffChange.getOldValue().getAvailable(), (double)nCollectionDiffChange.getNewValue().getCapacity()), nCollectionDiffChange.getOldValue().getLastRefill(), nCollectionDiffChange.getOldValue().getConfig()));
                    break;
                }
                case UNCHANGED: {
                    okkay.add(nCollectionDiffChange.getOldValue());
                }
            }
        }
        newModel = new NRateLimitValueModel(newModel.getId(), old.getLastAccess(), okkay.toArray(new NRateLimitRuleModel[0]));
        this.factory.save(newModel);
        return new NRateLimitValueImpl(newModel, this.factory);
    }

    @Override
    public NRateLimitRuleBuilder withLimit(String limitId) {
        this.lastRule = new NRateLimitRuleBuilderImpl(limitId, this);
        return this.lastRule;
    }

    private NRateLimitRuleBuilderImpl[] rules() {
        if (this.lastRule == null) {
            return this.rules.toArray(new NRateLimitRuleBuilderImpl[0]);
        }
        NRateLimitRuleBuilderImpl[] arr = Arrays.copyOf(this.rules.toArray(new NRateLimitRuleBuilderImpl[0]), this.rules.size() + 1);
        arr[arr.length - 1] = this.lastRule;
        return arr;
    }
}

