/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Deque;
import net.thevpc.nuts.concurrent.NRateLimitDefaultStrategy;
import net.thevpc.nuts.concurrent.NRateLimitRule;
import net.thevpc.nuts.concurrent.NRateLimitRuleModel;

public class NRateLimitSlidingWindowRule
implements NRateLimitRule {
    private String id;
    private int capacity;
    private Duration duration;
    private Deque<Long> timestamps;

    public NRateLimitSlidingWindowRule(NRateLimitRuleModel model) {
        this.id = model.getId();
        this.capacity = model.getCapacity();
        this.duration = model.getDuration() == 0L ? null : Duration.ofMillis(model.getDuration());
        this.timestamps = NRateLimitSlidingWindowRule.deserialize(model.getConfig());
    }

    @Override
    public synchronized boolean tryConsume(int count) {
        this.refill();
        if (this.timestamps.size() + count <= this.capacity) {
            long now = System.currentTimeMillis();
            for (int i = 0; i < count; ++i) {
                this.timestamps.addLast(now);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized long nextAvailableMillis(int count) {
        this.refill();
        if (this.timestamps.size() + count <= this.capacity) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long oldest = this.timestamps.peekFirst();
        long wait = this.duration.toMillis() - (now - oldest);
        return Math.max(wait, 0L);
    }

    public synchronized void refill() {
        long now = System.currentTimeMillis();
        long windowStart = now - this.duration.toMillis();
        while (!this.timestamps.isEmpty() && this.timestamps.peekFirst() < windowStart) {
            this.timestamps.removeFirst();
        }
    }

    @Override
    public synchronized NRateLimitRuleModel toModel() {
        Instant lastAccess = this.timestamps.isEmpty() ? Instant.now() : Instant.ofEpochMilli(this.timestamps.getLast());
        return new NRateLimitRuleModel(this.id, NRateLimitDefaultStrategy.SLIDING_WINDOW.id(), this.capacity, this.duration == null ? 0L : this.duration.toMillis(), this.capacity - this.timestamps.size(), lastAccess == null ? 0L : lastAccess.toEpochMilli(), NRateLimitSlidingWindowRule.serialize(this.timestamps));
    }

    private static byte[] serialize(Deque<Long> deque) {
        ByteBuffer buffer = ByteBuffer.allocate(deque.size() * 8);
        for (Long timestamp : deque) {
            buffer.putLong(timestamp);
        }
        return buffer.array();
    }

    private static Deque<Long> deserialize(byte[] bytes) {
        ArrayDeque<Long> deque = new ArrayDeque<Long>();
        if (bytes != null && bytes.length > 0) {
            try {
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                while (buffer.remaining() >= 8) {
                    deque.add(buffer.getLong());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return deque;
    }

    public String toString() {
        return "SlidingWindow{id='" + this.id + '\'' + ", capacity=" + this.capacity + ", duration=" + this.duration + '}';
    }
}

