/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.time.Instant;
import net.thevpc.nuts.concurrent.NRateLimitDefaultStrategy;
import net.thevpc.nuts.concurrent.NRateLimitRuleBuilder;
import net.thevpc.nuts.concurrent.NRateLimitValueBuilder;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitValueBuilderImpl;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NStringUtils;

class NRateLimitRuleBuilderImpl
implements NRateLimitRuleBuilder {
    private final NRateLimitValueBuilderImpl defaultNLimitedValueBuilder;
    private String id;
    private String strategy;
    private int max;
    private NDuration duration;
    private Instant startDate;

    public NRateLimitRuleBuilderImpl(String id, NRateLimitValueBuilderImpl defaultNLimitedValueBuilder) {
        this.id = id;
        this.defaultNLimitedValueBuilder = defaultNLimitedValueBuilder;
    }

    public NRateLimitRuleBuilderImpl setId(String id) {
        this.id = id;
        return this;
    }

    public Instant getStartDate() {
        return this.startDate;
    }

    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public NRateLimitRuleBuilder withCapacity(int capacity) {
        this.max = capacity;
        return this;
    }

    @Override
    public NRateLimitRuleBuilder withDuration(NDuration duration) {
        this.duration = duration;
        return this;
    }

    @Override
    public NRateLimitRuleBuilder withStrategy(String strategy) {
        this.strategy = NStringUtils.trimToNull(strategy);
        return this;
    }

    @Override
    public NRateLimitRuleBuilder withStartDate(Instant startDate) {
        return this;
    }

    @Override
    public NRateLimitRuleBuilder withStrategy(NRateLimitDefaultStrategy strategy) {
        this.strategy = strategy == null ? null : strategy.id();
        return this;
    }

    public String getId() {
        return this.id;
    }

    public int getMax() {
        return this.max;
    }

    public NDuration getDuration() {
        return this.duration;
    }

    @Override
    public NRateLimitValueBuilder end() {
        this.defaultNLimitedValueBuilder.rules.add(this);
        if (this == this.defaultNLimitedValueBuilder.lastRule) {
            this.defaultNLimitedValueBuilder.lastRule = null;
        }
        return this.defaultNLimitedValueBuilder;
    }
}

