/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.time.Duration;
import java.time.Instant;
import net.thevpc.nuts.concurrent.NRateLimitDefaultStrategy;
import net.thevpc.nuts.concurrent.NRateLimitRule;
import net.thevpc.nuts.concurrent.NRateLimitRuleModel;

public class NRateLimitFixedWindowRule
implements NRateLimitRule {
    private final String id;
    private final int capacity;
    private final Duration duration;
    private int available;
    private Instant lastRefill;

    public NRateLimitFixedWindowRule(NRateLimitRuleModel model) {
        this.id = model.getId();
        this.capacity = model.getCapacity();
        this.duration = model.getDuration() == 0L ? null : Duration.ofMillis(model.getDuration());
        this.available = (int)model.getAvailable();
        this.lastRefill = model.getLastRefill() == 0L ? null : Instant.ofEpochMilli(model.getLastRefill());
    }

    @Override
    public synchronized boolean tryConsume(int n) {
        Instant now = Instant.now();
        long elapsed = Duration.between(this.lastRefill, now).toMillis();
        if (elapsed >= this.duration.toMillis()) {
            this.available = 0;
            this.lastRefill = now;
        }
        if (this.available + n <= this.capacity) {
            this.available += n;
            return true;
        }
        return false;
    }

    @Override
    public synchronized long nextAvailableMillis(int n) {
        Instant now = Instant.now();
        long elapsed = Duration.between(this.lastRefill, now).toMillis();
        if (elapsed >= this.duration.toMillis()) {
            return 0L;
        }
        return this.available + n > this.capacity ? this.duration.toMillis() - elapsed : 0L;
    }

    @Override
    public synchronized NRateLimitRuleModel toModel() {
        return new NRateLimitRuleModel(this.id, NRateLimitDefaultStrategy.FIXED_WINDOW.id(), this.capacity, this.duration == null ? 0L : this.duration.toMillis(), this.available, this.lastRefill == null ? 0L : this.lastRefill.toEpochMilli(), new byte[0]);
    }

    public String toString() {
        return "FixedWindow{id='" + this.id + '\'' + ", capacity=" + this.capacity + ", duration=" + this.duration + '}';
    }
}

